<?php

/*
 * FORMA - The E-Learning Suite
 *
 * Copyright (c) 2013-2022 (Forma)
 * https://www.formalms.org
 * License https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 *
 * from docebo 4.0.5 CE 2008-2012 (c) docebo
 * License https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt
 */

define('_INSTALLER_TITLE', 'forma.lms - Installazione');
define('_INSTALL', 'Installazione');
define('_JUMP_TO_CONTENT', 'Salta al contenuto');

// choose begin

define('_SELECT_LANGUAGE', 'Seleziona la lingua');
define('_LANGUAGE', 'Lingua');
define('_LANG_INSTALLED', 'La lingua &egrave; stata installata');
define('_PLATFORM', 'Applicativo');

define('_ITALIAN', 'Italiano');
define('_ENGLISH', 'Inglese');
define('_FRENCH', 'Francese');
define('_SPANISH', 'Spagnolo');
define('_GERMAN', 'Tedesco');
define('_PORTUGUESE-BR', 'Portuguese-br');
define('_TAMIL', 'Tamil');
define('_CROATIAN', 'Croato');
define('_BOSNIAN', 'Bosniaco');

define('_TITLE_STEP1', 'Step 1: Seleziona la lingua');
define('_TITLE_STEP2', 'Step 2: Verifica informazioni di sistema');
define('_TITLE_STEP3', 'Step 3: Licenza');
define('_TITLE_STEP4', 'Step 4: Configurazione');
define('_TITLE_STEP5', "Step 5: Personalizzazione dell'installazione");
define('_TITLE_STEP6', 'Step 6: Importazione database');
define('_TITLE_STEP7', 'Step 7: Configurazione SMTP');
define('_TITLE_STEP8', 'Step 8: Installazione completata');
define('_INTRODUCTION', 'Introduzione');
define('_INSTALLATION_COMPLETED', 'Installazione completata');
define('REMOVE_INSTALL_FOLDER', 'Si suggerisce di rimuovere la cartella di installazione, Forma è vulnerabile fino a quando questa è raggiungibile.');
define('_INSTALLATION_DETAILS', 'Dettagli installazione');

define('_IS_PRESENT_DIRECTORIES', 'Sono ancora presenti delle directory non pi&ugrave; usate, ti consigliamo di cancellarle');
define('_LACKING_DIRECTORIES', 'Manacano alcune directory contenenti gli applicativi della suite, senza tali cartelle non sar&agrave; possibile usare il sistema');
define('_CANT_CONNECT_WITH_DB', 'Non &egrave; stato possibile connettersi al database, controlla i parametri inseriti');
define('_DB_NOT_EMPTY', 'Il database specificato non è vuoto');
define('_CANT_SELECT_DB', 'Non &egrave; stato possibile trovare il database specificato, controlla i parametri inseriti');
define('_CANT_CONNECT_WITH_FTP', 'Non &egrave; stato possibile connettersi tramite ftp al server specificato, controlla i parametri inseriti');
define('_SQL_STRICT_MODE_WARN', 'La modalit&agrave; <a href="http://dev.mysql.com/doc/en/server-sql-mode.html" target="_blank">strict mode</a> di MySQL &egrave; attiva; forma.lms non la supporta, ti preghiamo di disattivarla');
define('_SQL_STRICT_MODE', 'MySQL <a href="http://dev.mysql.com/doc/en/server-sql-mode.html" target="_blank">strict mode</a>');
define('_DB_WILL_BE_CREATED', 'Il database sarà creato');
define('_CHECKED_DIRECTORIES', 'Alcune delle directory per il salvataggio dei file non esistono oppure non hanno permessi adeguati');
define('_CHECKED_FILES', 'Alcuni file non hanno permessi adeguati');
define('_EMPTY_DIRECTORIES', '');

define('_SELECT_WHATINSTALL', 'Seleziona quali applicativi vuoi installare');
define('_WARNING_NOT_INSTALL', '<b>Attenzione</b>: se si deseleziona un applicativo non sar&agrave; pi&ugrave; possibile installarlo in futuro usando la procedura automatica.');

define('_FRAMEWORK', 'forma.lms Core Framework');
define('_LMS', 'forma.lms Learning Management System');
define('_ECOM', 'forma.lms E-Commerce');
define('_CMS', 'forma.lms Content Management System');
define('_KMS', 'forma.lms Knowledge Management System');
define('_SCS', 'forma.lms Syncronous Collaborative System');

define('_NEXT', 'Passo successivo');
define('_BACK', 'Torna indietro');
define('_REFRESH', 'Aggiorna');
define('_DOINSTALL', 'Installa');
define('_FINISH', 'Fine');

define('_DATABASE_INFO', 'Informazioni sul database');
define('_DB_HOST', 'Indirizzo');
define('_DB_TYPE', 'Tipo');
define('_DB_NAME', 'Nome database');
define('_DB_USERNAME', 'Nome utente');
define('_DB_PASS', 'Password');
define('_DB_CONFPASS', 'Conferma password');

define('_UPLOAD_METHOD', 'Metodo di caricamento dei file (suggerito FTP, se sei sul pc windows di casa usa HTTP)');
define('_HTTP_UPLOAD', 'Metodo classico (HTTP)');
define('_FTP_UPLOAD', 'Caricamento dei file tramite FTP');
define('_NOTAVAILABLE', 'Non disponibile');

define('_FTP_INFO', 'Informazioni accesso FTP');
define('_IF_FTP_SELECTED', '(se &egrave; stato selezionato FTP come metodo di upload)');
define('_FTP_HOST', 'Indirizzo del server');
define('_FTP_PORT', 'Numero porta (Di solito è corretto)');
define('_FTP_USERNAME', 'Nome utente');
define('_FTP_PASS', 'Password');
define('_FTP_CONFPASS', 'Conferma password');
define('_FTP_PATH', 'Percorso FTP (è dove sono archiviati i file, es. /htdocs/ /mainfile_html/)');

define('_SOFTWARE_LICENSE', 'Licenza software degli applicativi forma.lms');
define('_AGREE_LICENSE', 'Accetto i termini della licenza software');
define('_MUST_ACCEPT_LICENSE', "E' necessario accettare i termini della licenza software per continuare.");

define('_DOMXML_REQUIRED', 'Per installare la suite forma.lms &egrave; necessario che sia installato il modulo domxml o PHP 5 o successivo.');

define('_NUMBER_ESTIMATED_USERS', 'Numero di utenti registrati stimati');
define('_LESS_THAN50', 'Meno di 50');
define('_LESS_THAN150', 'Tra 50 e 150');
define('_MORE_THAN150', 'Pi&ugrave; di 150');
define('_MORE_THAN_ONE_BRANCH', 'La vostra ditta/associazione ha pi&ugrave; di una sede?');
define('_ANSWER_YES', 'S&igrave;');
define('_ANSWER_NO', 'No');
define('_ADMINISTRATION_TYPE', 'Tipo di amministrazione');
define('_ONE_ADMIN', 'Un solo amministratore');
define('_SUB_ADMINS', 'Amministratore e sottoamministratori');
define('_REQUIRE_ACCESSIBILITY', "E' richiesta la conformit&agrave; con gli standard di accessibilit&agrave; ?");
define('_REGISTRATION_TYPE', 'Tipo di registrazione');
define('_REG_TYPE_FREE', 'Registrazione libera');
define('_REG_TYPE_MOD', 'Registrazione moderata');
define('_REG_TYPE_ADMIN', "Solo l'amministratore pu&ograve; iscrivere nuovi utenti");
define('_SIMPLIFIED_INTERFACE', 'Opzioni di semplificazione delle interfacce');
define('_ADMIN_USER_INFO', "Informazioni sull'utente amministratore");
define('_ADMIN_USERNAME', 'Nome utente');
define('_ADMIN_FIRSTNAME', 'Nome');
define('_ADMIN_LASTNAME', 'Cognome');
define('_ADMIN_PASS', 'Password');
define('_ADMIN_CONFPASS', 'Conferma password');
define('_ADMIN_EMAIL', 'Indirizzo e-mail');
define('_LANG_TO_INSTALL', 'Lingue da installare');

define('_ADMIN_USERID_REQ', 'Username obbligatorio');
define('_ADMIN_PASS_REQ', 'Password obbligatoria');
define('_ADMIN_PASS_DOESNT_MATCH', 'Le password non corrispondono');
define('_NO_LANG_SELECTED', 'Nessuna lingua selezionata');

define('_WEBSITE_INFO', 'Informazioni sul sito web');
define('_DEFAULT_PLATFORM', 'Applicativo predefinito (home page)');
define('_SITE_DEFAULT_SENDER', 'Mittente predefinito dei messaggi e-mail automatici');
define('_SITE_BASE_URL', 'Url base del sito web (Non cambiare)');
define('_SITE_HOMEPAGE', 'Pagina iniziale');
define('_REVEAL_PASSWORD', 'Visualizza password');

define('_INVALID_USERNAME', 'Nome utente non valido.');
define('_INVALID_PASSWORD', 'Password non valida oppure le password non combaciano tra loro.');
define('_INVALID_EMAIL', 'Indirizzo e-mail non valido.');
define('_INVALID_DEFAULTSENDEREMAIL', 'Indirizzo e-mail del mittente predefinito non valido.');
define('_INVALID_SITEBASEURL', "Url base del sito non valido; l'indirizzo deve finire con \"/\".");

define('_DB_IMPORTING', 'Caricamento delle tabelle del database');
define('_DB_IMPORT_OK', 'Database caricato correttamente');
define('_DB_IMPORT_FAILED', 'Si sono verificati degli errori durante il caricamento del database');
define('_NEXT_IMPORT_LANG', "Ora verranno importati i linguaggi; l'operazione potrebbe impiegare del tempo (anche più di un minuto per modulo). Non chiudete il browser e cliccate \"passo successivo\" SOLO dopo che la pagina è stata completamente caricata. Se l'operazione non riesce chiedete al provider o amministratore del server di alzare il tempo massimo di esecuzione o usate la procedura manuale");

define('_CONFIGURATION', 'Configurazione');
define('_INSTALLATION_COMPLETE', 'Installazione completata');
define('_INSTALLATION_COMPLETE_MSG', 'Cursus adipiscing, rhoncus turpis platea cursus, quis hac! Urna enim eros sed rhoncus dis in turpis rhoncus, tortor. Pulvinar urna adipiscing et ac ac aenean etiam porta phasellus. Massa mattis risus. Cum et eros, integer turpis tincidunt lectus odio aliquet, et sed etiam dignissim est porta sed rhoncus a ut pid platea integer, elementum purus et proin, dapibus augue augue? Scelerisque sociis mid parturient augue, adipiscing, risus enim? Dolor eros in rhoncus? Mus a cras eros aliquam a tortor turpis. Porttitor velit pid sit? Integer nunc penatibus egestas, nunc cursus? Enim. Cras in elit lorem tristique! Augue lectus tincidunt elementum lundium nascetur risus magnis dignissim? Parturient ac adipiscing, porttitor mid? Et aliquam urna, sit ut in ultrices sit dolor! Mauris.');
define('_COPY_N_PASTE_CONFIG', "Copia e incolla il testo che trovi di seguito all'interno del file config.php");

define('_TO_ADMIN', "Per accedere all'interfaccia di amministrazione clicca il seguente link");
define('_TO_WEBSITE', 'Per accedere al sito principale clicca il seguente link');
define('_INSTALLED_APPS', 'Applicativi installati');

define('_REMOVE_INSTALL_FOLDERS_AND_WRITE_PERM', '<b>Attenzione:</b> Prima di procedere cancellare la cartella install/ dal sito e togliere i permessi di scrittura al file config.php impostandoli a 644');

// result
define('_FAILED_OPERATION', "Operazione fallita per l'operazione, codice dell'errore");
define('_SUCCESSFULL_OPERATION', 'Operazione avvenuta con successo per');
define('_CRITICAL_ERROR_UPGRADE_SUSPENDED', "Errore critico nell'aggiornamento, l'aggiornamento &egrave; stato interrotto");

// specific
define('_LMS_ENABLE_EVENT_UI', 'Gli utenti potranno configurare quali notifiche ricevere');
define('_LMS_ENABLE_GROUPSUB_UI', 'Gli utenti potranno configurare se iscriversi o meno ai gruppi');

//warnings
define('_WARNINGS', 'Avvertenze');
define('WARNING_PUB_ADMIN_DELETED', 'Verrano eliminati gli amministratori pubblici');

// diagnostic
define('_SERVERINFO', 'Informazioni sul server');
define('_SERVER_ADDR', 'Indirizzo server');
define('_SERVER_PORT', 'Porta server');
define('_SERVER_NAME', 'Nome server');
define('_SERVER_ADMIN', 'Amministratore server');
define('_SERVER_SOFTWARE', 'Server software');
define('_PHPINFO', 'PHP Info');
define('_PHPVERSION', 'PHP Version');
define('_MYSQLCLIENT_VERSION', 'Versione Client MySQL : ');
define('_MYSQLSERVER_VERSION', 'Versione Server MySQL : ');
define('_SAFEMODE', 'Safe mode');
define('_REGISTER_GLOBALS', 'register_global');
define('_ALLOW_URL_FOPEN', 'allow_url_fopen : ');
define('_ALLOW_URL_INCLUDE', 'allow_url_include : ');
define('_MAGIC_QUOTES_GPC', 'magic_quotes_gpc');
define('_UPLOAD_MAX_FILESIZE', 'upload_max_filsize');
define('_POST_MAX_SIZE', 'post_max_size');
define('_MAX_EXECUTION_TIME', 'max_execution_time');
define('_ALLOW_URL_INCLUDE', 'allow_url_include');
define('_DANGER', 'Pericolo - Settare ad OFF');
define('_DOMXML', 'domxml();');
define('_LDAP', 'Ldap');
define('_FILEINFO', 'Supporto Fileinfo');
define('_OPENSSL', 'Openssl : ');
define('_WARINNG_SOCIAL', 'Considerare questa nota solo se si intende usare i login social');
define('_ON', 'ON ');
define('_OFF', 'OFF ');
define('_NEXT_STEP', 'Passo successivo ');
define('_ONLY_IF_YU_WANT_TO_USE_IT', 'Considerare questa nota solo se si intende usare LDAP ');
define('_NOTSCORM', "Questo server non supporta domXML per php4 e non è php 5, non puoi installare forma.lms qui, chiedi al tuo provider di installare l'estensione domxml");
define('_YOU_DONT_HAVE_FUNCTION_OVERLOAD', 'la funzione overload non è attiva, per farla funzionare devi avere installato una versione di PHP uguale maggiore alla 4.3.0. Linux mandriva non è compilata con la funzione overload, cerca un file con un nome simile a php4-overload-xxxxx.mdk e installa tu il modulo, fedora core4 ha invece un bug <a href="http://download.fedora.redhat.com/pub/fedora/linux/core/updates/4/" target="_blank">che va patchato</a>. Se sei su windows ti consigliamo di installare <a href="http://www.easyphp.org" target="_blank">easyphp 1.8</a>.');
define('_CRITICAL_ERROR', 'Errore critico ');
define('_MBSTRING', 'Supporto Multibyte');
define('_PHP_TIMEZONE', 'Timezone Installazione');

define('_INSTALLER_INTRO_TEXT', 'forma.lms &egrave; un Learning Management System open source mantenuto da un gruppo di aziende italiane, già utilizzato da centinaia di grandi aziende ed universit&agrave; in tutto il mondo.
<p><strong>Key Features</strong></p>
<ul>
<li>Supporto a <em>Scorm 1.2 e 2004&nbsp;</em></li>
<li>Configurabile per adattarsi al modello didattico desiderato (autoapprendimento in&nbsp;<em>self-training</em>,&nbsp;<em>blended learning</em>,&nbsp;<em>collaborative learning</em>,&nbsp;<em>social learning</em>)</li>
<li>Authoring Tool per la gestione di <em>Test</em>, <em>Questionari</em>, <em>File download</em>&nbsp;di qualsiasi formato, <em>Pagine web</em>, <em>Faq</em>, <em>Glossari</em>, <em>Sitografie</em></li>
<li><em>Forum</em>, <em>Wiki</em>, <em>Chat</em>, <em>Project Management</em>,&nbsp;<em>Repository&nbsp;</em>(Consegna Relazioni)</li>
<li>Gestione delle <em>competenze</em>, <em>gap analysis</em> e <em>personal development plan</em></li>
<li>Emissione di <em>certificati pdf</em>&nbsp;</li>
<li> Interfacciamento con software per le risorse umane (<em>SAP</em>, <em>Cezanne</em>, <em>Lotus Notes</em>, ...) e altre realt&agrave; aziendali (<em>LDAP</em>, <em>Active Directory</em>, <em>Custom Made Solution</em>)</li>
<li>Interfacciamento con <em>Google Apps</em>, <em>Facebook</em>, <em>Twitter </em>e <em>Linkedin</em></li>
<li>Sistema di <em>report </em>e <em>business intelligence</em> completamente personalizzabile</li>
<li>Gestione di figure intermedie (<em>area manager</em>) per il monitoring e la gestione della formazione</li>
<li>Supporto multilingua e supporto <em>LTR</em>(left-to-right) e <em>RTL </em>(right-to-left)</li>
<li>Supporto per i <em>dispositivi Mobile</em></li>
</ul>');

define('_DOWNLOAD_CONFIG', 'Scarica file di configurazione');
define('_TRY_AGAIN', 'Riprova');
define('_LOADING', 'Caricamento');
define('_LANGUAGES', 'Linguaggi');

define('_UPGRADER_TITLE', 'forma.lms - Aggiornamento');
define('_UPGRADE_CONFIG', 'Aggiornamento del file config.php');
define('_UPG_CONFIG_OK', 'Config.php aggiornato correttamente');
define('_UPG_CONFIG_NOT_CHANGED', "Config.php gia' aggiornato");
define('_UPG_CONFIG_NOT_SAVED', 'config.php non salvato');
define('_UPGRADING', 'Aggiornamento in corso');
define('_UPGRADING_LANGUAGES', 'Aggiornamento linguaggi');
define('_UPGRADE_COMPLETE', 'Aggiornamento completato');
define('_VERSION', 'Versione forma.lms');
define('_START', 'Iniziale');
define('_END', 'Finale');
define('_INVALID_CONFIG_FILE', 'File config.php non valido; assicurati che sia della versione di forma.lms specificata alla voce "Iniziale"');
define('_UPGRADE_NOT_NEEDED', "Hai già l'ultima versione di forma.lms; non è necessario aggiornare.");
define('_UPGRADE_NOT_NEEDED_FILE_IS_LATER', "Sembra che la tua versione di forma.lms  sia successiva a quella dell'aggiornamento, nessun aggiornamento è necessario.");

define('_USEFUL_LINKS', 'Link utili');

define('_COMMUNITY', 'Community');
define('_COMMERCIAL_SERVICES', 'Servizi commerciali');
define('_DATABASE', 'Database');
define('_MIME_CONTENT_TYPE', 'Supporto mime_content_type()');

define('_ASSESSMENT_FUNCTION_REMOVED', 'La funzione assessment è stata rimossa');
define('_LEARNING_NEWS_REMOVED', 'La funzione news di login e relativa tabella è stata rimossa');

define('_SMTP_INFO', "Sarà possibile impostare la configurazione dell'SMTP da backoffice o da config.");
define('_USE_SMTP_DATABASE', 'Impostazioni SMTP su Database');
define('_USE_SMTP', 'Usa SMTP');
define('_SMTP_HOST', 'Host SMTP');
define('_SMTP_PORT', 'Porta SMTP');
define('_SMTP_SECURE', 'Tipo di sicurezza');
define('_SMTP_AUTO_TLS', 'Impostazione Auto TLS SMTP');
define('_SMTP_USER', 'User SMTP');
define('_SMTP_PWD', 'Password SMTP');
define('_SMTP_DEBUG', 'Debug SMTP');
define('_CANT_CONNECT_SMTP', 'impossibile connettersi al server SMTP selezionato');
