/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.sound;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.BigDecoder;
import com.flagstone.transform.sound.DefineSound;
import com.flagstone.transform.sound.SoundFormat;
import com.flagstone.transform.sound.SoundStreamBlock;
import com.flagstone.transform.sound.SoundStreamHead2;
import com.flagstone.transform.util.sound.SoundDecoder;
import com.flagstone.transform.util.sound.SoundProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public final class MP3Decoder
implements SoundProvider,
SoundDecoder {
    private static final int ID3_MASK = -256;
    private static final int ID3_V1 = 1413564160;
    private static final int ID3_V1_LENGTH = 128;
    private static final int ID3_V2 = 1229206272;
    private static final int ID3_V2_FOOTER = 10;
    private static final int MP3_SYNC = -2097152;
    private static final int MPEG1 = 3;
    private static final int[] MP3_FRAME_SIZE = new int[]{576, 576, 576, 1152};
    private static final int[] CHANNEL_COUNT = new int[]{2, 2, 2, 1};
    private static final int[][] BIT_RATES = new int[][]{{-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1}, {-1, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1}};
    private static final int[][] SAMPLE_RATES = new int[][]{{11025, -1, -1, -1}, {-1, -1, -1, -1}, {22050, -1, -1, -1}, {44100, -1, -1, -1}};
    private static final int SAMPLE_SIZE = 2;
    private transient float movieRate;
    private transient int numberOfChannels;
    private transient int samplesPerChannel;
    private transient int sampleRate;
    private transient byte[] sound;
    private transient BigDecoder coder;
    private transient int samplesPerFrame = 0;
    private transient byte[] frame;
    private transient int actualSamples;
    private transient int expectedSamples;

    @Override
    public SoundDecoder newDecoder() {
        return new MP3Decoder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file) throws IOException, DataFormatException {
        FileInputStream stream = new FileInputStream(file);
        try {
            this.read(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(URL url) throws IOException, DataFormatException {
        URLConnection connection = url.openConnection();
        int fileSize = connection.getContentLength();
        if (fileSize < 0) {
            throw new FileNotFoundException(url.getFile());
        }
        InputStream stream = url.openStream();
        try {
            this.read(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Override
    public void read(InputStream stream) throws IOException, DataFormatException {
        this.coder = new BigDecoder(stream);
        this.readFrame();
        this.actualSamples += this.samplesPerFrame;
    }

    @Override
    public DefineSound defineSound(int identifier) throws IOException, DataFormatException {
        this.sound = new byte[2];
        do {
            int length = this.sound.length;
            this.sound = Arrays.copyOf(this.sound, length + this.frame.length);
            System.arraycopy(this.frame, 0, this.sound, length, this.frame.length);
        } while (this.readFrame());
        return new DefineSound(identifier, SoundFormat.MP3, this.sampleRate, this.numberOfChannels, 2, this.samplesPerChannel, this.sound);
    }

    @Override
    public DefineSound defineSound(int identifier, float duration) throws IOException, DataFormatException {
        this.sound = new byte[2];
        for (float played = 0.0f; played < duration; played += (float)this.samplesPerFrame / (float)this.sampleRate) {
            int length = this.sound.length;
            this.sound = Arrays.copyOf(this.sound, length + this.frame.length);
            System.arraycopy(this.frame, 0, this.sound, length, this.frame.length);
            if (this.readFrame()) continue;
        }
        return new DefineSound(identifier, SoundFormat.MP3, this.sampleRate, this.numberOfChannels, 2, this.samplesPerChannel, this.sound);
    }

    @Override
    public MovieTag streamHeader(float frameRate) {
        this.movieRate = frameRate;
        return new SoundStreamHead2(SoundFormat.MP3, this.sampleRate, this.numberOfChannels, 2, this.sampleRate, this.numberOfChannels, 2, (int)((float)this.sampleRate / frameRate));
    }

    @Override
    public MovieTag streamSound() throws IOException, DataFormatException {
        int seek = this.expectedSamples > 0 ? this.actualSamples - this.expectedSamples : 0;
        this.expectedSamples = (int)((float)this.expectedSamples + (float)this.sampleRate / this.movieRate);
        this.sound = new byte[4];
        int sampleCount = 0;
        boolean hasFrames = true;
        do {
            int length = this.sound.length;
            this.sound = Arrays.copyOf(this.sound, length + this.frame.length);
            System.arraycopy(this.frame, 0, this.sound, length, this.frame.length);
            sampleCount += this.samplesPerFrame;
            hasFrames = this.readFrame();
            this.actualSamples += this.samplesPerFrame;
        } while (hasFrames && this.actualSamples < this.expectedSamples);
        SoundStreamBlock block = null;
        if (hasFrames) {
            this.sound[0] = (byte)sampleCount;
            this.sound[1] = (byte)(sampleCount >> 8);
            this.sound[2] = (byte)seek;
            this.sound[3] = (byte)(seek >> 8);
            block = new SoundStreamBlock(this.sound);
        }
        return block;
    }

    private boolean readFrame() throws IOException, DataFormatException {
        boolean frameRead = false;
        while (!this.coder.eof() && !frameRead) {
            int header = this.coder.scanInt();
            if (header == -1) {
                this.coder.readUnsignedShort();
                continue;
            }
            if ((header & 0xFFFFFF00) == 1413564160) {
                this.readID3V1();
                continue;
            }
            if ((header & 0xFFFFFF00) == 1229206272) {
                this.readID3V2();
                continue;
            }
            if ((header & 0xFFE00000) == -2097152) {
                this.readFrame(header);
                frameRead = true;
                continue;
            }
            this.coder.readUnsignedShort();
        }
        return !this.coder.eof();
    }

    private void readID3V1() throws IOException, DataFormatException {
        this.coder.skip(128);
    }

    private void readID3V2() throws IOException, DataFormatException {
        this.coder.readByte();
        this.coder.readByte();
        this.coder.readByte();
        this.coder.readByte();
        this.coder.readByte();
        int flags = this.coder.readByte();
        int length = (flags & 0x10) == 0 ? 0 : 10;
        length += this.coder.readByte() << 21;
        length += this.coder.readByte() << 14;
        length += this.coder.readByte() << 7;
        this.coder.skip(length += this.coder.readByte());
    }

    private void readFrame(int header) throws IOException, DataFormatException {
        int version = (header & 0x180000) >> 19;
        int layer = (header & 0x60000) >> 17;
        this.samplesPerFrame = MP3_FRAME_SIZE[version];
        int bitRate = BIT_RATES[version][(header & 0xF000) >> 12];
        this.sampleRate = SAMPLE_RATES[version][(header & 0xC00) >> 10];
        int padding = (header & 0x200) >> 9;
        if (layer != 1) {
            throw new DataFormatException("Flash only supports MPEG Layer 3");
        }
        if (bitRate == -1) {
            throw new DataFormatException("Unsupported Bit-rate");
        }
        if (this.sampleRate == -1) {
            throw new DataFormatException("Unsupported Sampling-rate");
        }
        this.numberOfChannels = CHANNEL_COUNT[(header & 0xC0) >> 6];
        this.samplesPerChannel += this.samplesPerFrame;
        int frameSize = 4 + ((version == 3 ? 144 : 72) * bitRate * 1000 / this.sampleRate + padding) - 4;
        this.frame = this.coder.readBytes(new byte[frameSize]);
    }
}

