/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

import com.flagstone.transform.util.image.ImageDecoder;
import com.flagstone.transform.util.image.ImageEncoding;
import com.flagstone.transform.util.image.ImageProvider;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ImageRegistry {
    private static Map<String, ImageProvider> providers = new LinkedHashMap<String, ImageProvider>();

    public static void registerProvider(String mimeType, ImageProvider decoder) {
        providers.put(mimeType, decoder);
    }

    public static ImageDecoder getImageProvider(String mimeType) {
        if (providers.containsKey(mimeType)) {
            return providers.get(mimeType).newDecoder();
        }
        throw new IllegalArgumentException();
    }

    private ImageRegistry() {
    }

    static {
        for (ImageEncoding encoding : ImageEncoding.values()) {
            ImageRegistry.registerProvider(encoding.getMimeType(), encoding.getProvider());
        }
    }
}

