/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.image;

public final class ImageFilter {
    private static final int RGB5_MSB_MASK = 248;
    private static final int R5_SHIFT = 7;
    private static final int G5_SHIFT = 2;
    private static final int B5_SHIFT = 3;
    private static final int OPAQUE = 255;
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    private static final int ALPHA = 3;
    private static final int RGBA_CHANNELS = 4;
    private static final int RGB_CHANNELS = 3;

    public byte[] removeAlpha(byte[] image) {
        byte[] out = new byte[image.length / 4 * 3];
        int dst = 0;
        for (int i = 0; i < image.length; i += 4) {
            out[dst++] = image[i];
            out[dst++] = image[i + 1];
            out[dst++] = image[i + 2];
        }
        return out;
    }

    public byte[] invertRGB(byte[] image, int width, int height) {
        byte[] out = new byte[image.length];
        int dst = 0;
        int src = 0;
        for (int row = height - 1; row >= 0; --row) {
            src = row * width;
            int col = 0;
            while (col < width) {
                out[dst++] = image[src];
                out[dst++] = image[src + 1];
                out[dst++] = image[src + 2];
                ++col;
                src += 3;
            }
        }
        return out;
    }

    public void reverseRGB(byte[] image) {
        for (int i = 0; i < image.length; i += 3) {
            byte swap = image[i];
            image[i] = image[i + 2];
            image[i + 2] = swap;
        }
    }

    public void reverseRGBA(byte[] image) {
        for (int i = 0; i < image.length; i += 4) {
            byte alpha;
            image[i + 0] = alpha = image[i + 3];
            image[i + 1] = image[i + 0];
            image[i + 2] = image[i + 1];
            image[i + 3] = image[i + 2];
        }
    }

    public byte[] packColors(int imgWidth, int imgHeight, byte[] img) {
        int src = 0;
        int dst = 0;
        int scan = imgWidth + (imgWidth & 1);
        byte[] formattedImage = new byte[scan * imgHeight * 2];
        for (int row = 0; row < imgHeight; ++row) {
            int col = 0;
            while (col < imgWidth) {
                int red = (img[src++] & 0xF8) << 7;
                int green = (img[src++] & 0xF8) << 2;
                int blue = (img[src++] & 0xF8) >> 3;
                int colour = (red | green | blue) & Short.MAX_VALUE;
                formattedImage[dst++] = (byte)(colour >> 8);
                formattedImage[dst++] = (byte)colour;
                ++col;
                ++src;
            }
            while (col < scan) {
                formattedImage[dst++] = 0;
                formattedImage[dst++] = 0;
                ++col;
            }
        }
        return formattedImage;
    }

    public byte[] adjustScan(int imgWidth, int imgHeight, byte[] img) {
        int src = 0;
        int dst = 0;
        int scan = 0;
        byte[] formattedImage = null;
        scan = imgWidth + 3 & 0xFFFFFFFC;
        formattedImage = new byte[scan * imgHeight];
        for (int row = 0; row < imgHeight; ++row) {
            int col;
            for (col = 0; col < imgWidth; ++col) {
                formattedImage[dst++] = img[src++];
            }
            while (col++ < scan) {
                formattedImage[dst++] = 0;
            }
        }
        return formattedImage;
    }

    public void orderAlpha(byte[] img) {
        for (int i = 0; i < img.length; i += 4) {
            byte alpha = img[i + 3];
            img[i + 3] = img[i + 2];
            img[i + 2] = img[i + 1];
            img[i + 1] = img[i + 0];
            img[i + 0] = alpha;
        }
    }

    public void orderABGR(byte[] img) {
        for (int i = 0; i < img.length; i += 4) {
            byte swap = img[i + 3];
            img[i + 3] = img[i + 0];
            img[i + 0] = swap;
            swap = img[i + 2];
            img[i + 2] = img[i + 1];
            img[i + 1] = swap;
        }
    }

    public void applyAlpha(byte[] img) {
        for (int i = 0; i < img.length; i += 4) {
            int alpha = img[i + 3] & 0xFF;
            img[i + 0] = (byte)((img[i + 0] & 0xFF) * alpha / 255);
            img[i + 1] = (byte)((img[i + 1] & 0xFF) * alpha / 255);
            img[i + 2] = (byte)((img[i + 2] & 0xFF) * alpha / 255);
        }
    }

    public byte[] merge(byte[] img, byte[] colors) {
        int entries = colors.length / 4;
        byte[] merged = new byte[entries * 3 + img.length];
        int dst = 0;
        for (int i = 0; i < colors.length; i += 4) {
            merged[dst++] = colors[i + 2];
            merged[dst++] = colors[i + 1];
            merged[dst++] = colors[i + 0];
        }
        for (byte element : img) {
            merged[dst++] = element;
        }
        return merged;
    }

    public byte[] mergeAlpha(byte[] img, byte[] colors) {
        byte[] merged = new byte[colors.length + img.length];
        int dst = 0;
        for (byte element : colors) {
            merged[dst++] = element;
        }
        for (byte element : img) {
            merged[dst++] = element;
        }
        return merged;
    }
}

