/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util.font;

import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.font.CharacterFormat;
import com.flagstone.transform.util.font.Font;
import com.flagstone.transform.util.font.FontFace;
import com.flagstone.transform.util.font.Glyph;
import com.flagstone.transform.util.shape.Canvas;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;

public final class AWTDecoder {
    private static final int SEGMENT_COUNT = 6;
    private static final int XCOORD = 0;
    private static final int YCOORD = 1;
    private static final int QUAD_CTRLX = 0;
    private static final int QUAD_CTRLY = 1;
    private static final int QUAD_ANCHORX = 2;
    private static final int QUAD_ANCHORY = 3;
    private static final int CUBE_CTRL1_X = 0;
    private static final int CUBE_CTRL1_Y = 1;
    private static final int CUBE_CTRL2_X = 2;
    private static final int CUBE_CTRL2_Y = 3;
    private static final int CUBE_ANCHORX = 4;
    private static final int CUBE_ANCHORY = 5;
    private static final float EM_SQUARE_SIZE = 1024.0f;
    private final transient List<Font> fonts = new ArrayList<Font>();

    public void read(java.awt.Font font) throws IOException, DataFormatException {
        this.decode(font);
    }

    public List<Font> getFonts() {
        return this.fonts;
    }

    private void decode(java.awt.Font aFont) {
        FontRenderContext fontContext = new FontRenderContext(new AffineTransform(), true, true);
        java.awt.Font awtFont = aFont.deriveFont(1.0f);
        Font font = new Font();
        font.setFace(new FontFace(awtFont.getName(), awtFont.isBold(), awtFont.isItalic()));
        font.setEncoding(CharacterFormat.UCS2);
        AffineTransform affine = AffineTransform.getTranslateInstance(0.0, 0.0);
        awtFont = awtFont.deriveFont(affine);
        awtFont = awtFont.deriveFont(1024.0f);
        int missingGlyph = awtFont.getMissingGlyphCode();
        int count = awtFont.getNumGlyphs();
        font.setMissingGlyph(missingGlyph);
        font.setNumberOfGlyphs(count);
        font.setHighestChar('\uffff');
        int index = 0;
        GlyphVector glyphVector = awtFont.createGlyphVector(fontContext, new int[]{missingGlyph});
        Shape outline = glyphVector.getGlyphOutline(0);
        int advance = (int)glyphVector.getGlyphMetrics(0).getAdvance();
        font.addGlyph((char)missingGlyph, new Glyph(this.convertShape(outline), new Bounds(0, 0, 0, 0), advance));
        index = 1;
        float ascent = 0.0f;
        float descent = 0.0f;
        float leading = 0.0f;
        for (int code = 0; index < count && code < 65535; ++code) {
            char character;
            if (awtFont.canDisplay(code)) {
                character = (char)code;
                glyphVector = awtFont.createGlyphVector(fontContext, new char[]{character});
                outline = glyphVector.getGlyphOutline(0);
                advance = (int)glyphVector.getGlyphMetrics(0).getAdvance();
                font.addGlyph(character, new Glyph(this.convertShape(outline), new Bounds(0, 0, 0, 0), advance));
                if (!awtFont.hasUniformLineMetrics()) {
                    LineMetrics lineMetrics = awtFont.getLineMetrics(new char[]{character}, 0, 1, fontContext);
                    ascent = Math.max(lineMetrics.getAscent(), ascent);
                    descent = Math.max(lineMetrics.getDescent(), descent);
                    leading = Math.max(lineMetrics.getLeading(), leading);
                }
                ++index;
                continue;
            }
            character = (char)missingGlyph;
            font.addMissingGlyph((char)code);
        }
        font.setAscent((int)ascent);
        font.setDescent((int)descent);
        font.setLeading((int)leading);
        this.fonts.add(font);
    }

    private com.flagstone.transform.shape.Shape convertShape(Shape glyph) {
        PathIterator pathIter = glyph.getPathIterator(null);
        Canvas path = new Canvas();
        double[] coords = new double[6];
        while (!pathIter.isDone()) {
            switch (pathIter.currentSegment(coords)) {
                case 0: {
                    path.close();
                    path.moveForFont((int)coords[0], (int)coords[1]);
                    break;
                }
                case 1: {
                    path.line((int)coords[0], (int)coords[1]);
                    break;
                }
                case 2: {
                    path.curve((int)coords[0], (int)coords[1], (int)coords[2], (int)coords[3]);
                    break;
                }
                case 3: {
                    path.curve((int)coords[0], (int)coords[1], (int)coords[2], (int)coords[3], (int)coords[4], (int)coords[5]);
                    break;
                }
                case 4: {
                    path.close();
                    break;
                }
            }
            pathIter.next();
        }
        return path.getShape();
    }
}

