/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.text;

import com.flagstone.transform.DefineTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.datatype.HorizontalAlign;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class DefineTextField
implements DefineTag {
    private static final int MAX_SPACE = 65535;
    private int identifier;
    private Bounds bounds;
    private boolean wordWrapped;
    private boolean multiline;
    private boolean password;
    private boolean readOnly;
    private transient int reserved1;
    private boolean selectable;
    private boolean bordered;
    private transient boolean reserved2;
    private boolean html;
    private boolean embedded;
    private boolean autoSize;
    private int fontIdentifier;
    private String fontClass;
    private int fontHeight;
    private Color color;
    private int maxLength;
    private int alignment;
    private Integer leftMargin;
    private Integer rightMargin;
    private Integer indent;
    private Integer leading;
    private String variableName = "";
    private String initialText = "";
    private transient int length;

    public DefineTextField(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        context.put(3, 1);
        this.bounds = new Bounds(coder);
        int bits = coder.readByte();
        boolean containsText = (bits & 0x80) != 0;
        this.wordWrapped = (bits & 0x40) != 0;
        this.multiline = (bits & 0x20) != 0;
        this.password = (bits & 0x10) != 0;
        this.readOnly = (bits & 8) != 0;
        boolean containsColor = (bits & 4) != 0;
        boolean containsMaxLength = (bits & 2) != 0;
        boolean containsFont = (bits & 1) != 0;
        bits = coder.readByte();
        boolean containsClass = (bits & 0x80) != 0;
        this.autoSize = (bits & 0x40) != 0;
        boolean containsLayout = (bits & 0x20) != 0;
        this.selectable = (bits & 0x10) != 0;
        this.bordered = (bits & 8) != 0;
        this.reserved2 = (bits & 4) != 0;
        this.html = (bits & 2) != 0;
        boolean bl = this.embedded = (bits & 1) != 0;
        if (containsFont) {
            this.fontIdentifier = coder.readUnsignedShort();
            if (containsClass) {
                this.fontClass = coder.readString();
            }
            this.fontHeight = coder.readUnsignedShort();
        }
        if (containsColor) {
            this.color = new Color(coder, context);
        }
        if (containsMaxLength) {
            this.maxLength = coder.readUnsignedShort();
        }
        if (containsLayout) {
            this.alignment = coder.readByte();
            this.leftMargin = coder.readUnsignedShort();
            this.rightMargin = coder.readUnsignedShort();
            this.indent = coder.readUnsignedShort();
            this.leading = coder.readSignedShort();
        }
        this.variableName = coder.readString();
        if (containsText) {
            this.initialText = coder.readString();
        }
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineTextField(int uid) {
        this.setIdentifier(uid);
    }

    public DefineTextField(DefineTextField object) {
        this.identifier = object.identifier;
        this.bounds = object.bounds;
        this.wordWrapped = object.wordWrapped;
        this.multiline = object.multiline;
        this.password = object.password;
        this.readOnly = object.readOnly;
        this.reserved1 = object.reserved1;
        this.selectable = object.selectable;
        this.bordered = object.bordered;
        this.reserved2 = object.reserved2;
        this.html = object.html;
        this.embedded = object.embedded;
        this.autoSize = object.autoSize;
        this.fontIdentifier = object.fontIdentifier;
        this.fontClass = object.fontClass;
        this.fontHeight = object.fontHeight;
        this.color = object.color;
        this.maxLength = object.maxLength;
        this.alignment = object.alignment;
        this.leftMargin = object.leftMargin;
        this.rightMargin = object.rightMargin;
        this.indent = object.indent;
        this.leading = object.leading;
        this.variableName = object.variableName;
        this.initialText = object.initialText;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public boolean isWordWrapped() {
        return this.wordWrapped;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public DefineTextField setAutoSize(boolean aFlag) {
        this.autoSize = aFlag;
        return this;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public int getFontIdentifier() {
        return this.fontIdentifier;
    }

    public String getFontClass() {
        return this.fontClass;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public Color getColor() {
        return this.color;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public HorizontalAlign getAlignment() {
        HorizontalAlign value;
        switch (this.alignment) {
            case 0: {
                value = HorizontalAlign.LEFT;
                break;
            }
            case 1: {
                value = HorizontalAlign.RIGHT;
                break;
            }
            case 2: {
                value = HorizontalAlign.CENTER;
                break;
            }
            case 3: {
                value = HorizontalAlign.JUSTIFY;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return value;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getIndent() {
        return this.indent;
    }

    public int getLeading() {
        return this.leading;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getInitialText() {
        return this.initialText;
    }

    public DefineTextField setBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = rect;
        return this;
    }

    public DefineTextField setWordWrapped(boolean aFlag) {
        this.wordWrapped = aFlag;
        return this;
    }

    public DefineTextField setMultiline(boolean aFlag) {
        this.multiline = aFlag;
        return this;
    }

    public DefineTextField setPassword(boolean aFlag) {
        this.password = aFlag;
        return this;
    }

    public DefineTextField setReadOnly(boolean aFlag) {
        this.readOnly = aFlag;
        return this;
    }

    public DefineTextField setSelectable(boolean aFlag) {
        this.selectable = aFlag;
        return this;
    }

    public DefineTextField setBordered(boolean aFlag) {
        this.bordered = aFlag;
        return this;
    }

    public DefineTextField setHtml(boolean aFlag) {
        this.html = aFlag;
        return this;
    }

    public DefineTextField setEmbedded(boolean aFlag) {
        this.embedded = aFlag;
        return this;
    }

    public DefineTextField setFontIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.fontIdentifier = uid;
        this.fontClass = null;
        return this;
    }

    public DefineTextField setFontClass(String name) {
        this.fontClass = name;
        this.fontIdentifier = 0;
        return this;
    }

    public DefineTextField setFontHeight(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.fontHeight = aNumber;
        return this;
    }

    public DefineTextField setColor(Color aColor) {
        this.color = aColor == null ? new Color(0, 0, 0) : aColor;
        return this;
    }

    public DefineTextField setMaxLength(int aNumber) {
        if (aNumber < 0 || aNumber > 65535) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.maxLength = aNumber;
        return this;
    }

    public DefineTextField setAlignment(HorizontalAlign align) {
        switch (align) {
            case LEFT: {
                this.alignment = 0;
                break;
            }
            case RIGHT: {
                this.alignment = 1;
                break;
            }
            case CENTER: {
                this.alignment = 2;
                break;
            }
            case JUSTIFY: {
                this.alignment = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public DefineTextField setLeftMargin(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.leftMargin = aNumber;
        return this;
    }

    public DefineTextField setRightMargin(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.rightMargin = aNumber;
        return this;
    }

    public DefineTextField setIndent(Integer aNumber) {
        if (aNumber != null && (aNumber < 0 || aNumber > 65535)) {
            throw new IllegalArgumentRangeException(0, 65535, aNumber);
        }
        this.indent = aNumber;
        return this;
    }

    public DefineTextField setLeading(Integer aNumber) {
        if (aNumber < Short.MIN_VALUE || aNumber > Short.MAX_VALUE) {
            throw new IllegalArgumentRangeException(Short.MIN_VALUE, Short.MAX_VALUE, aNumber);
        }
        this.leading = aNumber;
        return this;
    }

    public DefineTextField setVariableName(String aString) {
        this.variableName = aString;
        return this;
    }

    public DefineTextField setInitialText(String aString) {
        this.initialText = aString;
        return this;
    }

    @Override
    public DefineTextField copy() {
        return new DefineTextField(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DefineTextField: { identifier = ").append(this.identifier);
        builder.append("; bounds = ").append(this.bounds.toString());
        builder.append("; wordWrapped = ").append(this.wordWrapped);
        builder.append("; multiline = ").append(this.multiline);
        builder.append("; password = ").append(this.password);
        builder.append("; readOnly = ").append(this.readOnly);
        builder.append("; autoSize = ").append(this.autoSize);
        builder.append("; selectable = ").append(this.selectable);
        builder.append("; bordered = ").append(this.bordered);
        builder.append("; HTML = ").append(this.html);
        builder.append("; embedded = ").append(this.embedded);
        builder.append("; fontIdentifier = ").append(this.fontIdentifier).append(";");
        builder.append("; fontHeight = ").append(this.fontHeight);
        builder.append("; color = ").append(this.color);
        builder.append("; maxLength = ").append(this.maxLength);
        builder.append("; alignment = ").append(this.alignment);
        builder.append("; leftMargin = ").append(this.leftMargin);
        builder.append("; rightMargin = ").append(this.rightMargin);
        builder.append("; indent = ").append(this.indent);
        builder.append("; leading = ").append(this.leading);
        builder.append("; variableName = ").append(this.variableName);
        builder.append("; initalText = ").append(this.initialText);
        builder.append(" }");
        return builder.toString();
    }

    @Override
    public int prepareToEncode(Context context) {
        context.put(3, 1);
        this.length = 2 + this.bounds.prepareToEncode(context);
        this.length += 2;
        this.length += this.fontIdentifier == 0 ? 0 : 4;
        this.length += this.fontClass == null ? 0 : context.strlen(this.fontClass) + 2;
        this.length += this.color == null ? 0 : 4;
        this.length += this.maxLength > 0 ? 2 : 0;
        this.length += this.containsLayout() ? 9 : 0;
        this.length += context.strlen(this.variableName);
        this.length += this.initialText == null ? 0 : context.strlen(this.initialText);
        context.remove(3);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2431);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x940 | this.length);
        }
        coder.mark();
        context.put(3, 1);
        coder.writeShort(this.identifier);
        this.bounds.encode(coder, context);
        int bits = 0;
        bits |= this.initialText == null ? 0 : 128;
        bits |= this.wordWrapped ? 64 : 0;
        bits |= this.multiline ? 32 : 0;
        bits |= this.password ? 16 : 0;
        bits |= this.readOnly ? 8 : 0;
        bits |= this.color == null ? 0 : 4;
        bits |= this.maxLength > 0 ? 2 : 0;
        coder.writeByte(bits |= this.fontIdentifier == 0 ? 0 : 1);
        bits = 0;
        bits |= this.fontClass == null ? 0 : 128;
        bits |= this.autoSize ? 64 : 0;
        bits |= this.containsLayout() ? 32 : 0;
        bits |= this.selectable ? 16 : 0;
        bits |= this.bordered ? 8 : 0;
        bits |= this.reserved2 ? 4 : 0;
        bits |= this.html ? 2 : 0;
        coder.writeByte(bits |= this.embedded ? 1 : 0);
        if (this.fontIdentifier > 0) {
            coder.writeShort(this.fontIdentifier);
            coder.writeShort(this.fontHeight);
        } else if (this.fontClass != null) {
            coder.writeString(this.fontClass);
            coder.writeShort(this.fontHeight);
        }
        if (this.color != null) {
            this.color.encode(coder, context);
        }
        if (this.maxLength > 0) {
            coder.writeShort(this.maxLength);
        }
        if (this.containsLayout()) {
            coder.writeByte(this.alignment);
            coder.writeShort(this.leftMargin == null ? 0 : this.leftMargin);
            coder.writeShort(this.rightMargin == null ? 0 : this.rightMargin);
            coder.writeShort(this.indent == null ? 0 : this.indent);
            coder.writeShort(this.leading == null ? 0 : this.leading);
        }
        coder.writeString(this.variableName);
        if (this.initialText != null) {
            coder.writeString(this.initialText);
        }
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }

    private boolean containsLayout() {
        return this.leftMargin != null || this.rightMargin != null || this.indent != null || this.leading != null;
    }
}

