/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.sound;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.exception.IllegalArgumentValueException;
import com.flagstone.transform.sound.SoundFormat;
import java.io.IOException;

public final class SoundStreamHead2
implements MovieTag {
    private static final String FORMAT = "SoundStreamHead2: { format=%s; playbackRate=%d; playbackChannels=%d; playbackSampleSize=%d; streamRate=%d; streamChannels=%d; streamSampleSize=%d; streamSampleCount=%d; latency=%d}";
    private int format;
    private int playRate;
    private int playChannels;
    private int playSampleSize;
    private int streamRate;
    private int streamChannels;
    private int streamSampleSize;
    private int streamSampleCount;
    private int latency;
    private transient int length;
    private transient int reserved = 0;

    public SoundStreamHead2(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        int info = coder.readByte();
        this.reserved = (info & 0xF0) >> 4;
        this.playRate = this.readRate(info & 0xC);
        this.playSampleSize = ((info & 2) >> 1) + 1;
        this.playChannels = (info & 1) + 1;
        info = coder.readByte();
        this.format = (info & 0xF0) >> 4;
        this.streamRate = this.readRate(info & 0xC);
        this.streamSampleSize = ((info & 2) >> 1) + 1;
        this.streamChannels = (info & 1) + 1;
        this.streamSampleCount = coder.readUnsignedShort();
        if (this.length == 6 && this.format == 2) {
            this.latency = coder.readSignedShort();
        }
        coder.check(this.length);
        coder.unmark();
    }

    public SoundStreamHead2(SoundFormat encoding, int playbackRate, int playbackChannels, int playSize, int streamingRate, int streamingChannels, int streamingSize, int streamingCount) {
        this.setFormat(encoding);
        this.setPlayRate(playbackRate);
        this.setPlayChannels(playbackChannels);
        this.setPlaySampleSize(playSize);
        this.setStreamRate(streamingRate);
        this.setStreamChannels(streamingChannels);
        this.setStreamSampleSize(streamingSize);
        this.setStreamSampleCount(streamingCount);
    }

    public SoundStreamHead2(SoundStreamHead2 object) {
        this.format = object.format;
        this.playRate = object.playRate;
        this.playChannels = object.playChannels;
        this.playSampleSize = object.playSampleSize;
        this.streamRate = object.streamRate;
        this.streamChannels = object.streamChannels;
        this.streamSampleSize = object.streamSampleSize;
        this.streamSampleCount = object.streamSampleCount;
        this.latency = object.latency;
    }

    public SoundFormat getFormat() {
        return SoundFormat.fromInt(this.format);
    }

    public void setFormat(SoundFormat encoding) {
        this.format = encoding.getValue();
    }

    public int getPlayRate() {
        return this.playRate;
    }

    public int getPlayChannels() {
        return this.playChannels;
    }

    public int getPlaySampleSize() {
        return this.playSampleSize;
    }

    public float getStreamRate() {
        return this.streamRate;
    }

    public int getStreamChannels() {
        return this.streamChannels;
    }

    public int getStreamSampleSize() {
        return this.streamSampleSize;
    }

    public int getStreamSampleCount() {
        return this.streamSampleCount;
    }

    public void setPlayRate(int rate) {
        if (rate != 5512 && rate != 11025 && rate != 22050 && rate != 44100) {
            throw new IllegalArgumentValueException(new int[]{5512, 11025, 22050, 44100}, rate);
        }
        this.playRate = rate;
    }

    public void setPlayChannels(int channels) {
        if (channels < 1 || channels > 2) {
            throw new IllegalArgumentRangeException(1, 2, channels);
        }
        this.playChannels = channels;
    }

    public void setPlaySampleSize(int playSize) {
        if (playSize < 1 || playSize > 2) {
            throw new IllegalArgumentRangeException(1, 2, playSize);
        }
        this.playSampleSize = playSize;
    }

    public void setStreamRate(int rate) {
        if (rate != 5512 && rate != 11025 && rate != 22050 && rate != 44100) {
            throw new IllegalArgumentValueException(new int[]{5512, 11025, 22050, 44100}, rate);
        }
        this.streamRate = rate;
    }

    public void setStreamChannels(int channels) {
        if (channels < 1 || channels > 2) {
            throw new IllegalArgumentRangeException(1, 2, channels);
        }
        this.streamChannels = channels;
    }

    public void setStreamSampleSize(int size) {
        if (size < 1 || size > 2) {
            throw new IllegalArgumentRangeException(1, 2, size);
        }
        this.streamSampleSize = size;
    }

    public void setStreamSampleCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentRangeException(0, Integer.MAX_VALUE, count);
        }
        this.streamSampleCount = count;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int delay) {
        this.latency = delay;
    }

    @Override
    public SoundStreamHead2 copy() {
        return new SoundStreamHead2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.format, this.playRate, this.playChannels, this.playSampleSize, this.streamRate, this.streamChannels, this.streamSampleSize, this.streamSampleCount, this.latency);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 4;
        if (this.format == 2 && this.latency > 0) {
            this.length += 2;
        }
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2943);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xB40 | this.length);
        }
        coder.mark();
        int bits = this.reserved << 4;
        bits |= this.writeRate(this.playRate);
        bits |= this.playSampleSize - 1 << 1;
        coder.writeByte(bits |= this.playChannels - 1);
        bits = this.format << 4;
        bits |= this.writeRate(this.streamRate);
        bits |= this.streamSampleSize - 1 << 1;
        coder.writeByte(bits |= this.streamChannels - 1);
        coder.writeShort(this.streamSampleCount);
        if (this.format == 2 && this.latency > 0) {
            coder.writeShort(this.latency);
        }
        coder.check(this.length);
        coder.unmark();
    }

    private int readRate(int value) {
        int rate;
        switch (value) {
            case 0: {
                rate = 5512;
                break;
            }
            case 4: {
                rate = 11025;
                break;
            }
            case 8: {
                rate = 22050;
                break;
            }
            case 12: {
                rate = 44100;
                break;
            }
            default: {
                rate = 0;
            }
        }
        return rate;
    }

    private int writeRate(int rate) {
        int value;
        switch (rate) {
            case 11025: {
                value = 4;
                break;
            }
            case 22050: {
                value = 8;
                break;
            }
            case 44100: {
                value = 12;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }
}

