/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.shape.ShapeRecord;
import java.io.IOException;
import java.util.Arrays;

public final class ShapeData
implements ShapeRecord {
    private static final String FORMAT = "ShapeData: byte<%d> ...";
    private final transient byte[] data;

    public ShapeData(int size, SWFDecoder coder) throws IOException {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.data = coder.readBytes(new byte[size]);
    }

    public ShapeData(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        this.data = Arrays.copyOf(bytes, bytes.length);
    }

    public ShapeData(ShapeData object) {
        this.data = object.data;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public ShapeData copy() {
        return new ShapeData(this);
    }

    public String toString() {
        return String.format(FORMAT, this.data.length);
    }

    @Override
    public int prepareToEncode(Context context) {
        return this.data.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeBytes(this.data);
    }
}

