/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.linestyle.LineStyle;
import com.flagstone.transform.linestyle.LineStyle1;
import com.flagstone.transform.linestyle.LineStyle2;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeData;
import com.flagstone.transform.shape.ShapeTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineShape4
implements ShapeTag {
    private static final int EXTENDED = 255;
    private static final int EXTENDED_LENGTH = 3;
    private static final String FORMAT = "DefineShape4: { identifier=%d; shapeBounds=%s; edgeBounds=%s; fillStyles=%s; lineStyles=%s; winding=%b; shape=%s}";
    private int identifier;
    private Bounds bounds;
    private Bounds edgeBounds;
    private List<FillStyle> fillStyles;
    private List<LineStyle> lineStyles;
    private Shape shape;
    private transient int winding;
    private transient int scaling;
    private transient int length;
    private transient int fillBits;
    private transient int lineBits;

    public DefineShape4(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        context.put(3, 1);
        context.put(2, 83);
        this.bounds = new Bounds(coder);
        this.edgeBounds = new Bounds(coder);
        this.winding = coder.readByte() & 4;
        int fillStyleCount = coder.readByte();
        if (fillStyleCount == 255) {
            fillStyleCount = coder.readUnsignedShort();
        }
        this.fillStyles = new ArrayList<FillStyle>();
        this.lineStyles = new ArrayList<LineStyle>();
        SWFFactory<FillStyle> decoder = context.getRegistry().getFillStyleDecoder();
        for (int i = 0; i < fillStyleCount; ++i) {
            decoder.getObject(this.fillStyles, coder, context);
        }
        int lineStyleCount = coder.readByte();
        if (lineStyleCount == 255) {
            lineStyleCount = coder.readUnsignedShort();
        }
        for (int i = 0; i < lineStyleCount; ++i) {
            this.lineStyles.add(new LineStyle2(coder, context));
        }
        context.put(8, 1);
        if (context.getRegistry().getShapeDecoder() == null) {
            this.shape = new Shape();
            this.shape.add(new ShapeData(this.length - coder.bytesRead(), coder));
        } else {
            this.shape = new Shape(coder, context);
        }
        context.remove(3);
        context.remove(8);
        context.remove(2);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineShape4(int uid, Bounds rect, Bounds edges, List<FillStyle> fills, List<LineStyle> lines, Shape aShape) {
        this.setIdentifier(uid);
        this.setBounds(rect);
        this.setEdgeBounds(edges);
        this.setFillStyles(fills);
        this.setLineStyles(lines);
        this.setShape(aShape);
    }

    public DefineShape4(DefineShape4 object) {
        this.identifier = object.identifier;
        this.bounds = object.bounds;
        this.edgeBounds = object.edgeBounds;
        this.fillStyles = new ArrayList<FillStyle>(object.fillStyles.size());
        for (FillStyle fillStyle : object.fillStyles) {
            this.fillStyles.add((FillStyle)fillStyle.copy());
        }
        this.lineStyles = new ArrayList<LineStyle>(object.lineStyles.size());
        for (LineStyle lineStyle : object.lineStyles) {
            this.lineStyles.add((LineStyle)lineStyle.copy());
        }
        this.shape = object.shape.copy();
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = rect;
    }

    public Bounds getEdgeBounds() {
        return this.edgeBounds;
    }

    public void setEdgeBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.edgeBounds = rect;
    }

    @Override
    public DefineShape4 add(LineStyle style) {
        if (style == null || style instanceof LineStyle1) {
            throw new IllegalArgumentException();
        }
        this.lineStyles.add(style);
        return this;
    }

    @Override
    public DefineShape4 add(FillStyle style) {
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles.add(style);
        return this;
    }

    @Override
    public List<FillStyle> getFillStyles() {
        return this.fillStyles;
    }

    @Override
    public List<LineStyle> getLineStyles() {
        return this.lineStyles;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setFillStyles(List<FillStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles = list;
    }

    @Override
    public void setLineStyles(List<LineStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.lineStyles = list;
    }

    @Override
    public void setShape(Shape aShape) {
        if (aShape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = aShape;
    }

    public boolean useWinding() {
        return this.winding != 0;
    }

    public void setWinding(boolean use) {
        this.winding = use ? 4 : 0;
    }

    @Override
    public DefineShape4 copy() {
        return new DefineShape4(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.bounds, this.edgeBounds, this.fillStyles, this.lineStyles, this.useWinding(), this.shape);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.fillBits = Coder.unsignedSize(this.fillStyles.size());
        this.lineBits = Coder.unsignedSize(this.lineStyles.size());
        if (context.contains(9)) {
            if (this.fillBits == 0) {
                this.fillBits = 1;
            }
            if (this.lineBits == 0) {
                this.lineBits = 1;
            }
        }
        context.put(3, 1);
        this.length = 3;
        this.length += this.bounds.prepareToEncode(context);
        this.length += this.edgeBounds.prepareToEncode(context);
        this.length += this.fillStyles.size() >= 255 ? 3 : 1;
        for (FillStyle fillStyle : this.fillStyles) {
            this.length += fillStyle.prepareToEncode(context);
        }
        context.put(10, 0);
        this.length += this.lineStyles.size() >= 255 ? 3 : 1;
        for (LineStyle lineStyle : this.lineStyles) {
            this.length += lineStyle.prepareToEncode(context);
        }
        this.scaling = context.get(10);
        context.put(8, 1);
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.length += this.shape.prepareToEncode(context);
        context.remove(8);
        context.put(11, 0);
        context.put(12, 0);
        context.remove(3);
        context.remove(10);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        context.put(3, 1);
        if (this.length > 62) {
            coder.writeShort(5375);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x14C0 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        this.bounds.encode(coder, context);
        this.edgeBounds.encode(coder, context);
        coder.writeByte(this.winding | this.scaling);
        if (this.fillStyles.size() >= 255) {
            coder.writeByte(255);
            coder.writeShort(this.fillStyles.size());
        } else {
            coder.writeByte(this.fillStyles.size());
        }
        for (FillStyle fillStyle : this.fillStyles) {
            fillStyle.encode(coder, context);
        }
        if (this.lineStyles.size() >= 255) {
            coder.writeByte(255);
            coder.writeShort(this.lineStyles.size());
        } else {
            coder.writeByte(this.lineStyles.size());
        }
        for (LineStyle lineStyle : this.lineStyles) {
            lineStyle.encode(coder, context);
        }
        context.put(8, 1);
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.shape.encode(coder, context);
        context.remove(8);
        context.put(11, 0);
        context.put(12, 0);
        context.remove(3);
        coder.check(this.length);
        coder.unmark();
    }
}

