/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.shape;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.datatype.Bounds;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import com.flagstone.transform.fillstyle.FillStyle;
import com.flagstone.transform.linestyle.LineStyle;
import com.flagstone.transform.linestyle.LineStyle1;
import com.flagstone.transform.linestyle.LineStyle2;
import com.flagstone.transform.shape.Shape;
import com.flagstone.transform.shape.ShapeData;
import com.flagstone.transform.shape.ShapeTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DefineShape2
implements ShapeTag {
    private static final int EXTENDED = 255;
    private static final int EXTENDED_LENGTH = 3;
    private static final String FORMAT = "DefineShape2: { identifier=%d; bounds=%s; fillStyles=%s; lineStyles=%s; shape=%s}";
    private int identifier;
    private Bounds bounds;
    private List<FillStyle> fillStyles;
    private List<LineStyle> lineStyles;
    private Shape shape;
    private transient int length;
    private transient int fillBits;
    private transient int lineBits;

    public DefineShape2(SWFDecoder coder, Context context) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.identifier = coder.readUnsignedShort();
        this.bounds = new Bounds(coder);
        this.fillStyles = new ArrayList<FillStyle>();
        this.lineStyles = new ArrayList<LineStyle>();
        context.put(8, 1);
        context.put(2, 22);
        int fillStyleCount = coder.readByte();
        if (fillStyleCount == 255) {
            fillStyleCount = coder.readUnsignedShort();
        }
        SWFFactory<FillStyle> decoder = context.getRegistry().getFillStyleDecoder();
        for (int i = 0; i < fillStyleCount; ++i) {
            decoder.getObject(this.fillStyles, coder, context);
        }
        int lineStyleCount = coder.readByte();
        if (lineStyleCount == 255) {
            lineStyleCount = coder.readUnsignedShort();
        }
        for (int i = 0; i < lineStyleCount; ++i) {
            this.lineStyles.add(new LineStyle1(coder, context));
        }
        if (context.getRegistry().getShapeDecoder() == null) {
            this.shape = new Shape();
            this.shape.add(new ShapeData(this.length - coder.bytesRead(), coder));
        } else {
            this.shape = new Shape(coder, context);
        }
        context.remove(8);
        context.remove(2);
        coder.check(this.length);
        coder.unmark();
    }

    public DefineShape2(int uid, Bounds rect, List<FillStyle> fills, List<LineStyle> lines, Shape aShape) {
        this.setIdentifier(uid);
        this.setBounds(rect);
        this.setFillStyles(fills);
        this.setLineStyles(lines);
        this.setShape(aShape);
    }

    public DefineShape2(DefineShape2 object) {
        this.identifier = object.identifier;
        this.bounds = object.bounds;
        this.fillStyles = new ArrayList<FillStyle>(object.fillStyles.size());
        for (FillStyle fillStyle : object.fillStyles) {
            this.fillStyles.add((FillStyle)fillStyle.copy());
        }
        this.lineStyles = new ArrayList<LineStyle>(object.lineStyles.size());
        for (LineStyle lineStyle : object.lineStyles) {
            this.lineStyles.add((LineStyle)lineStyle.copy());
        }
        this.shape = object.shape.copy();
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int uid) {
        if (uid < 1 || uid > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, uid);
        }
        this.identifier = uid;
    }

    @Override
    public DefineShape2 add(LineStyle style) {
        if (style == null || style instanceof LineStyle2) {
            throw new IllegalArgumentException();
        }
        this.lineStyles.add(style);
        return this;
    }

    @Override
    public DefineShape2 add(FillStyle style) {
        if (style == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles.add(style);
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public List<FillStyle> getFillStyles() {
        return this.fillStyles;
    }

    @Override
    public List<LineStyle> getLineStyles() {
        return this.lineStyles;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public void setBounds(Bounds rect) {
        if (rect == null) {
            throw new IllegalArgumentException();
        }
        this.bounds = rect;
    }

    @Override
    public void setFillStyles(List<FillStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.fillStyles = list;
    }

    @Override
    public void setLineStyles(List<LineStyle> list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.lineStyles = list;
    }

    @Override
    public void setShape(Shape aShape) {
        if (aShape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = aShape;
    }

    @Override
    public DefineShape2 copy() {
        return new DefineShape2(this);
    }

    public String toString() {
        return String.format(FORMAT, this.identifier, this.bounds, this.fillStyles, this.lineStyles, this.shape);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.fillBits = Coder.unsignedSize(this.fillStyles.size());
        this.lineBits = Coder.unsignedSize(this.lineStyles.size());
        if (context.contains(9)) {
            if (this.fillBits == 0) {
                this.fillBits = 1;
            }
            if (this.lineBits == 0) {
                this.lineBits = 1;
            }
        }
        this.length = 2 + this.bounds.prepareToEncode(context);
        this.length += this.fillStyles.size() >= 255 ? 3 : 1;
        for (FillStyle fillStyle : this.fillStyles) {
            this.length += fillStyle.prepareToEncode(context);
        }
        this.length += this.lineStyles.size() >= 255 ? 3 : 1;
        for (LineStyle lineStyle : this.lineStyles) {
            this.length += lineStyle.prepareToEncode(context);
        }
        context.put(8, 1);
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.length += this.shape.prepareToEncode(context);
        context.remove(8);
        context.put(11, 0);
        context.put(12, 0);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(1471);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0x580 | this.length);
        }
        coder.mark();
        coder.writeShort(this.identifier);
        this.bounds.encode(coder, context);
        if (this.fillStyles.size() >= 255) {
            coder.writeByte(255);
            coder.writeShort(this.fillStyles.size());
        } else {
            coder.writeByte(this.fillStyles.size());
        }
        for (FillStyle fillStyle : this.fillStyles) {
            fillStyle.encode(coder, context);
        }
        if (this.lineStyles.size() >= 255) {
            coder.writeByte(255);
            coder.writeShort(this.lineStyles.size());
        } else {
            coder.writeByte(this.lineStyles.size());
        }
        for (LineStyle lineStyle : this.lineStyles) {
            lineStyle.encode(coder, context);
        }
        context.put(8, 1);
        context.put(11, this.fillBits);
        context.put(12, this.lineBits);
        this.shape.encode(coder, context);
        context.remove(8);
        context.put(11, 0);
        context.put(12, 0);
        coder.check(this.length);
        coder.unmark();
    }
}

