/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.Copyable;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.font.AlignmentZone;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class GlyphAlignment
implements SWFEncodeable,
Copyable<GlyphAlignment> {
    private static final String FORMAT = "GlyphAlignment: { alignments=%s; alignX=%s; alignY=%s}";
    private List<AlignmentZone> alignments;
    private transient int masks;

    public GlyphAlignment(SWFDecoder coder) throws IOException {
        int count = coder.readByte();
        this.alignments = new ArrayList<AlignmentZone>(count);
        for (int i = 0; i < count; ++i) {
            this.alignments.add(new AlignmentZone(coder));
        }
        this.masks = coder.readByte();
    }

    public GlyphAlignment(List<AlignmentZone> list, boolean xAlign, boolean yAlign) {
        this.setAlignments(list);
        this.setAlignmentX(xAlign);
        this.setAlignmentY(yAlign);
    }

    public GlyphAlignment(GlyphAlignment object) {
        this.alignments = new ArrayList<AlignmentZone>(object.alignments);
        this.masks = object.masks;
    }

    public boolean alignmentX() {
        return (this.masks & 1) != 0;
    }

    public void setAlignmentX(boolean hasAlign) {
        this.masks &= 0xFFFFFFFE;
        if (hasAlign) {
            this.masks |= 1;
        }
    }

    public boolean alignmentY() {
        return (this.masks & 2) != 0;
    }

    public void setAlignmentY(boolean hasAlign) {
        this.masks &= 0xFFFFFFFD;
        if (hasAlign) {
            this.masks |= 2;
        }
    }

    public List<AlignmentZone> getAlignments() {
        return this.alignments;
    }

    public void setAlignments(List<AlignmentZone> list) {
        this.alignments = list;
    }

    @Override
    public GlyphAlignment copy() {
        return new GlyphAlignment(this);
    }

    public String toString() {
        return String.format(FORMAT, this.alignments, String.valueOf(this.alignmentX()), String.valueOf(this.alignmentY()));
    }

    @Override
    public int prepareToEncode(Context context) {
        return 10;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(2);
        for (AlignmentZone zone : this.alignments) {
            zone.encode(coder, context);
        }
        coder.writeByte(this.masks);
    }
}

