/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.font;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class AlignmentZone
implements SWFEncodeable {
    private static final String FORMAT = "AlignmentZone: { coordinate=%f; range=%f}";
    private final transient float coordinate;
    private final transient float range;

    public AlignmentZone(SWFDecoder coder) throws IOException {
        this.coordinate = coder.readHalf();
        this.range = coder.readHalf();
    }

    public AlignmentZone(float coord, float size) {
        this.coordinate = coord;
        this.range = size;
    }

    public float getCoordinate() {
        return this.coordinate;
    }

    public float getRange() {
        return this.range;
    }

    public String toString() {
        return String.format(FORMAT, Float.valueOf(this.coordinate), Float.valueOf(this.range));
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof AlignmentZone) {
            AlignmentZone zone = (AlignmentZone)object;
            result = this.coordinate == zone.coordinate && this.range == zone.range;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.coordinate) * 31 + Float.floatToIntBits(this.range);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 4;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeHalf(this.coordinate);
        coder.writeHalf(this.range);
    }
}

