/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.filter;

import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.datatype.Color;
import com.flagstone.transform.filter.Filter;
import java.io.IOException;
import java.util.Arrays;

public final class ConvolutionFilter
implements Filter {
    private static final String FORMAT = "ConvolutionFilter: { matrix=%s; divisor=%f; bias=%f; color=%s; clamp=%b; alpha=%b}";
    private final transient float[][] matrix;
    private final transient float divisor;
    private final transient float bias;
    private final transient Color color;
    private final transient boolean clamp;
    private final transient boolean alpha;
    private transient int rows;
    private transient int cols;

    public ConvolutionFilter(Builder builder) {
        this.matrix = builder.matrix;
        this.divisor = builder.divisor;
        this.bias = builder.bias;
        this.color = builder.color;
        this.clamp = builder.clamp;
        this.alpha = builder.alpha;
    }

    public ConvolutionFilter(SWFDecoder coder, Context context) throws IOException {
        this.cols = coder.readByte();
        this.rows = coder.readByte();
        this.divisor = Float.intBitsToFloat(coder.readInt());
        this.bias = Float.intBitsToFloat(coder.readInt());
        this.matrix = new float[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.matrix[i][j] = Float.intBitsToFloat(coder.readInt());
            }
        }
        this.color = new Color(coder, context);
        int bits = coder.readByte();
        this.clamp = (bits & 2) != 0;
        this.alpha = (bits & 1) != 0;
    }

    public float getDivisor() {
        return this.divisor;
    }

    public float getBias() {
        return this.divisor;
    }

    public float[][] getMatrix() {
        return (float[][])this.matrix.clone();
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isClamp() {
        return this.clamp;
    }

    public boolean isAlpha() {
        return this.alpha;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.matrix.length; ++i) {
            builder.append(Arrays.toString(this.matrix[i]));
        }
        builder.append("]");
        return String.format(FORMAT, builder.toString(), Float.valueOf(this.divisor), Float.valueOf(this.bias), this.color, this.clamp, this.alpha);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof ConvolutionFilter) {
            ConvolutionFilter filter = (ConvolutionFilter)object;
            result = Arrays.deepEquals((Object[])this.matrix, (Object[])filter.matrix) && this.divisor == filter.divisor && this.bias == filter.bias && this.color.equals(filter.color) && this.clamp == filter.clamp && this.alpha == filter.alpha;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return ((((Arrays.deepHashCode((Object[])this.matrix) * 31 + Float.floatToIntBits(this.divisor)) * 31 + Float.floatToIntBits(this.bias)) * 31 + this.color.hashCode()) * 31 + Boolean.valueOf(this.clamp).hashCode()) * 31 + Boolean.valueOf(this.alpha).hashCode();
    }

    @Override
    public int prepareToEncode(Context context) {
        this.rows = this.matrix.length;
        this.cols = this.matrix[0].length;
        return 16 + this.rows * this.cols * 4;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(5);
        coder.writeByte(this.cols);
        coder.writeByte(this.rows);
        coder.writeInt(Float.floatToIntBits(this.divisor));
        coder.writeInt(Float.floatToIntBits(this.bias));
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                coder.writeInt(Float.floatToIntBits(this.matrix[i][j]));
            }
        }
        this.color.encode(coder, context);
        int bits = 0;
        bits |= this.clamp ? 2 : 0;
        coder.writeByte(bits |= this.alpha ? 1 : 0);
    }

    public static final class Builder {
        private transient float[][] matrix;
        private transient float divisor;
        private transient float bias;
        private transient Color color;
        private transient boolean clamp;
        private transient boolean alpha;

        public Builder setMatrix(float[][] aMatrix) {
            int rows = aMatrix.length;
            int cols = aMatrix[0].length;
            this.matrix = new float[rows][cols];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    this.matrix[i][j] = aMatrix[i][j];
                }
            }
            return this;
        }

        public Builder setDivisor(float value) {
            this.divisor = value;
            return this;
        }

        public Builder setBias(float value) {
            this.bias = value;
            return this;
        }

        public Builder setColor(Color aColor) {
            this.color = aColor;
            return this;
        }

        public Builder setClamp(boolean nearest) {
            this.clamp = nearest;
            return this;
        }

        public Builder setAlpha(boolean preserve) {
            this.alpha = preserve;
            return this;
        }

        public ConvolutionFilter build() {
            return new ConvolutionFilter(this);
        }
    }
}

