/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.datatype;

import com.flagstone.transform.coder.Coder;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncodeable;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class CoordTransform
implements SWFEncodeable {
    private static final int ROUND_TO_BYTES = 7;
    private static final int BITS_TO_BYTES = 3;
    private static final String FORMAT = "CoordTransform: { scaleX=%f; scaleY=%f; shearX=%f; shearY=%f; transX=%d; transY=%d}";
    public static final float DEFAULT_SCALE = 1.0f;
    public static final float DEFAULT_SHEAR = 0.0f;
    public static final int DEFAULT_COORD = 0;
    public static final float SCALE_FACTOR = 65536.0f;
    public static final float SHEAR_FACTOR = 65536.0f;
    private static final int FIELD_SIZE = 5;
    private static final int DEFAULT_INT_SCALE = 65536;
    private static final int DEFAULT_INT_SHEAR = 0;
    private final transient int scaleX;
    private final transient int scaleY;
    private final transient int shearX;
    private final transient int shearY;
    private final transient int translateX;
    private final transient int translateY;
    private transient boolean hasScale;
    private transient boolean hasShear;
    private transient int scaleSize;
    private transient int shearSize;
    private transient int transSize;

    public static float[][] product(float[][] left, float[][] right) {
        return new float[][]{{left[0][0] * right[0][0] + left[0][1] * right[1][0] + left[0][2] * right[2][0], left[0][0] * right[0][1] + left[0][1] * right[1][1] + left[0][2] * right[2][1], left[0][0] * right[0][2] + left[0][1] * right[1][2] + left[0][2] * right[2][2]}, {left[1][0] * right[0][0] + left[1][1] * right[1][0] + left[1][2] * right[2][0], left[1][0] * right[0][1] + left[1][1] * right[1][1] + left[1][2] * right[2][1], left[1][0] * right[0][2] + left[1][1] * right[1][2] + left[1][2] * right[2][2]}, {left[2][0] * right[0][0] + left[2][1] * right[1][0] + left[2][2] * right[2][0], left[2][0] * right[0][1] + left[2][1] * right[1][1] + left[2][2] * right[2][1], left[2][0] * right[0][2] + left[2][1] * right[1][2] + left[2][2] * right[2][2]}};
    }

    public static CoordTransform translate(int xCoord, int yCoord) {
        return new CoordTransform(1.0f, 1.0f, 0.0f, 0.0f, xCoord, yCoord);
    }

    public static CoordTransform scale(float xScale, float yScale) {
        return new CoordTransform(xScale, yScale, 0.0f, 0.0f, 0, 0);
    }

    public static CoordTransform shear(float xShear, float yShear) {
        return new CoordTransform(1.0f, 1.0f, xShear, yShear, 0, 0);
    }

    public static CoordTransform rotate(int angle) {
        double radians = Math.toRadians(angle);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        return new CoordTransform((float)cos, (float)cos, (float)sin, -((float)sin), 0, 0);
    }

    public CoordTransform(SWFDecoder coder) throws IOException {
        coder.alignToByte();
        boolean bl = this.hasScale = coder.readBits(1, false) != 0;
        if (this.hasScale) {
            this.scaleSize = coder.readBits(5, false);
            this.scaleX = coder.readBits(this.scaleSize, true);
            this.scaleY = coder.readBits(this.scaleSize, true);
        } else {
            this.scaleX = 65536;
            this.scaleY = 65536;
        }
        boolean bl2 = this.hasShear = coder.readBits(1, false) != 0;
        if (this.hasShear) {
            this.shearSize = coder.readBits(5, false);
            this.shearX = coder.readBits(this.shearSize, true);
            this.shearY = coder.readBits(this.shearSize, true);
        } else {
            this.shearX = 0;
            this.shearY = 0;
        }
        this.transSize = coder.readBits(5, false);
        this.translateX = coder.readBits(this.transSize, true);
        this.translateY = coder.readBits(this.transSize, true);
        coder.alignToByte();
    }

    public CoordTransform(float[][] matrix) {
        this.scaleX = (int)(matrix[0][0] * 65536.0f);
        this.scaleY = (int)(matrix[1][1] * 65536.0f);
        this.shearX = (int)(matrix[1][0] * 65536.0f);
        this.shearY = (int)(matrix[0][1] * 65536.0f);
        this.translateX = (int)matrix[0][2];
        this.translateY = (int)matrix[1][2];
    }

    public CoordTransform(float xScale, float yScale, float xShear, float yShear, int xCoord, int yCoord) {
        this.scaleX = (int)(xScale * 65536.0f);
        this.scaleY = (int)(yScale * 65536.0f);
        this.shearX = (int)(xShear * 65536.0f);
        this.shearY = (int)(yShear * 65536.0f);
        this.translateX = xCoord;
        this.translateY = yCoord;
    }

    public float getScaleX() {
        return (float)this.scaleX / 65536.0f;
    }

    public float getScaleY() {
        return (float)this.scaleY / 65536.0f;
    }

    public float getShearX() {
        return (float)this.shearX / 65536.0f;
    }

    public float getShearY() {
        return (float)this.shearY / 65536.0f;
    }

    public int getTranslateX() {
        return this.translateX;
    }

    public int getTranslateY() {
        return this.translateY;
    }

    public float[][] getMatrix() {
        return new float[][]{{(float)this.scaleX / 65536.0f, (float)this.shearY / 65536.0f, this.translateX}, {(float)this.shearX / 65536.0f, (float)this.scaleY / 65536.0f, this.translateY}, {0.0f, 0.0f, 1.0f}};
    }

    public String toString() {
        return String.format(FORMAT, Float.valueOf(this.getScaleX()), Float.valueOf(this.getScaleY()), Float.valueOf(this.getShearX()), Float.valueOf(this.getShearY()), this.translateX, this.translateY);
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == null) {
            result = false;
        } else if (object == this) {
            result = true;
        } else if (object instanceof CoordTransform) {
            CoordTransform transform = (CoordTransform)object;
            result = this.scaleX == transform.scaleX && this.scaleY == transform.scaleY && this.shearX == transform.shearX && this.shearY == transform.shearY && this.translateX == transform.translateX && this.translateY == transform.translateY;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return ((((this.scaleX * 31 + this.scaleY) * 31 + this.shearX) * 31 + this.shearY) * 31 + this.translateX) * 31 + this.translateY;
    }

    @Override
    public int prepareToEncode(Context context) {
        int numberOfBits = 14;
        this.hasScale = this.scaleX != 65536 || this.scaleY != 65536;
        this.hasShear = this.shearX != 0 || this.shearY != 0;
        this.transSize = this.hasScale || this.hasShear || this.translateX != 0 || this.translateY != 0 ? Math.max(Coder.size(this.translateX), Coder.size(this.translateY)) : 0;
        numberOfBits += this.transSize << 1;
        if (this.hasScale) {
            this.scaleSize = Math.max(Coder.size(this.scaleX), Coder.size(this.scaleY));
            numberOfBits += 5 + (this.scaleSize << 1);
        }
        if (this.hasShear) {
            this.shearSize = Math.max(Coder.size(this.shearX), Coder.size(this.shearY));
            numberOfBits += 5 + (this.shearSize << 1);
        }
        return numberOfBits >> 3;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.hasScale) {
            coder.writeBits(1, 1);
            coder.writeBits(this.scaleSize, 5);
            coder.writeBits(this.scaleX, this.scaleSize);
            coder.writeBits(this.scaleY, this.scaleSize);
        } else {
            coder.writeBits(0, 1);
        }
        if (this.hasShear) {
            coder.writeBits(1, 1);
            coder.writeBits(this.shearSize, 5);
            coder.writeBits(this.shearX, this.shearSize);
            coder.writeBits(this.shearY, this.shearSize);
        } else {
            coder.writeBits(0, 1);
        }
        coder.writeBits(this.transSize, 5);
        coder.writeBits(this.translateX, this.transSize);
        coder.writeBits(this.translateY, this.transSize);
        coder.alignToByte();
    }
}

