/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.datatype;

import java.util.LinkedHashMap;
import java.util.Map;

public enum Blend {
    NULL(0),
    NORMAL(1),
    LAYER(2),
    MULTIPLY(3),
    SCREEN(4),
    LIGHTEN(5),
    DARKEN(6),
    ADD(7),
    SUBTRACT(8),
    DIFFERENCE(9),
    INVERT(10),
    ALPHA(11),
    ERASE(12),
    OVERLAY(13),
    HARDLIGHT(14);

    private static final Map<Integer, Blend> TABLE;
    private final int value;

    public static Blend fromInt(int type) {
        return TABLE.get(type);
    }

    private Blend(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    static {
        TABLE = new LinkedHashMap<Integer, Blend>();
        for (Blend format : Blend.values()) {
            TABLE.put(format.value, format);
        }
    }
}

