/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.coder.SWFFactory;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class NewFunction2
implements Action {
    private static final int LAST_REGISTER = 255;
    private static final String FORMAT = "NewFunction2: { name=%s; registerCount=%d; optimizations=%s; arguments=%s; actions=%s}";
    private static final int INITIAL_LENGTH = 5;
    private final transient String name;
    private final transient int registerCount;
    private final transient int optimizations;
    private final transient Map<String, Integer> arguments;
    private final transient List<Action> actions;
    private transient int length;
    private transient int actionsLength;

    public NewFunction2(Builder builder) {
        this.name = builder.name;
        this.registerCount = builder.registerCount;
        this.optimizations = builder.optimizations;
        this.arguments = new LinkedHashMap<String, Integer>(builder.arguments);
        this.actions = new ArrayList<Action>(builder.actions);
    }

    public NewFunction2(SWFDecoder coder, Context context) throws IOException {
        SWFFactory<Action> decoder = context.getRegistry().getActionDecoder();
        this.length = coder.readUnsignedShort();
        this.name = coder.readString();
        int argumentCount = coder.readUnsignedShort();
        this.registerCount = coder.readByte();
        this.optimizations = (coder.readByte() << 8) + coder.readByte();
        this.arguments = new LinkedHashMap<String, Integer>(argumentCount);
        for (int i = 0; i < argumentCount; ++i) {
            int index = coder.readByte();
            this.arguments.put(coder.readString(), index);
        }
        this.actionsLength = coder.readUnsignedShort();
        coder.mark();
        this.length += this.actionsLength;
        this.actions = new ArrayList<Action>();
        while (coder.bytesRead() < this.actionsLength) {
            decoder.getObject(this.actions, coder, context);
        }
        coder.check(this.actionsLength);
        coder.unmark();
    }

    public NewFunction2(String aString, int count, Set<Optimization> opts, Map<String, Integer> map, List<Action> list) {
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.name = aString;
        if (count < 0 || count > 255) {
            throw new IllegalArgumentRangeException(0, 255, count);
        }
        this.registerCount = count;
        int value = 0;
        for (Optimization opt : opts) {
            value |= opt.getValue();
        }
        this.optimizations = value;
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.arguments = map;
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.actions = list;
    }

    public NewFunction2(NewFunction2 object) {
        this.name = object.name;
        this.registerCount = object.registerCount;
        this.optimizations = object.optimizations;
        this.arguments = new LinkedHashMap<String, Integer>(object.arguments);
        this.actions = new ArrayList<Action>(object.actions);
    }

    public String getName() {
        return this.name;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public Set<Optimization> getOptimizations() {
        EnumSet<Optimization> set = EnumSet.noneOf(Optimization.class);
        for (Optimization opt : EnumSet.allOf(Optimization.class)) {
            if ((this.optimizations & opt.getValue()) == 0) continue;
            set.add(opt);
        }
        return set;
    }

    public Map<String, Integer> getArguments() {
        return new LinkedHashMap<String, Integer>(this.arguments);
    }

    public List<Action> getActions() {
        return new ArrayList<Action>(this.actions);
    }

    @Override
    public NewFunction2 copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.name, this.registerCount, this.optimizations, this.arguments, this.actions);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 5 + context.strlen(this.name);
        for (String arg : this.arguments.keySet()) {
            this.length += arg.getBytes().length + 2;
        }
        this.length += 2;
        this.actionsLength = this.actions.isEmpty() ? 1 : 0;
        for (Action action : this.actions) {
            this.actionsLength += action.prepareToEncode(context);
        }
        this.length += this.actionsLength;
        return 3 + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(142);
        coder.writeShort(this.length - this.actionsLength);
        coder.writeString(this.name);
        coder.writeShort(this.arguments.size());
        coder.writeByte(this.registerCount);
        coder.writeByte(this.optimizations >>> 8);
        coder.writeByte(this.optimizations);
        for (String arg : this.arguments.keySet()) {
            coder.writeByte(this.arguments.get(arg));
            coder.writeString(arg);
        }
        coder.writeShort(this.actionsLength);
        for (Action action : this.actions) {
            action.encode(coder, context);
        }
        if (this.actions.isEmpty()) {
            coder.writeByte(0);
        }
    }

    public static enum Optimization {
        CREATE_SUPER(4),
        CREATE_ARGUMENTS(16),
        CREATE_THIS(64),
        LOAD_THIS(128),
        LOAD_ARGUMENTS(32),
        LOAD_SUPER(8),
        LOAD_ROOT(2),
        LOAD_PARENT(1),
        LOAD_GLOBAL(32768);

        private static final Map<Integer, Optimization> TABLE;
        private final int value;

        private Optimization(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            TABLE = new LinkedHashMap<Integer, Optimization>();
            for (Optimization opt : Optimization.values()) {
                TABLE.put(opt.value, opt);
            }
        }
    }

    public static final class Builder {
        private transient String name = "";
        private transient int registerCount;
        private transient int optimizations;
        private final transient Map<String, Integer> arguments = new LinkedHashMap<String, Integer>();
        private final transient List<Action> actions = new ArrayList<Action>();

        public Builder setName(String aString) {
            if (aString == null || aString.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.name = aString;
            return this;
        }

        public Builder allocate(int count) {
            if (count < 0 || count > 255) {
                throw new IllegalArgumentRangeException(0, 255, count);
            }
            this.registerCount = count;
            return this;
        }

        public Builder optimize(Optimization opt) {
            this.optimizations |= opt.getValue();
            return this;
        }

        public Builder addArgument(String argName) {
            return this.addArgument(argName, 0);
        }

        public Builder addArgument(String argName, int index) {
            if (argName == null || argName.length() == 0) {
                throw new IllegalArgumentException();
            }
            if (index < 0 || index > 255) {
                throw new IllegalArgumentRangeException(0, 255, index);
            }
            this.arguments.put(argName, index);
            return this;
        }

        public Builder addAction(Action action) {
            if (action == null) {
                throw new IllegalArgumentException();
            }
            this.actions.add(action);
            return this;
        }

        public NewFunction2 build() {
            return new NewFunction2(this);
        }
    }
}

