/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.action;

import com.flagstone.transform.action.Action;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import com.flagstone.transform.exception.IllegalArgumentRangeException;
import java.io.IOException;

public final class GotoFrame
implements Action {
    private static final String FORMAT = "GotoFrame: { frameNumber=%d}";
    private static final int MAX_FRAME_OFFSET = 65535;
    private final transient int frameNumber;

    public GotoFrame(SWFDecoder coder) throws IOException {
        coder.readUnsignedShort();
        this.frameNumber = coder.readUnsignedShort();
    }

    public GotoFrame(int number) {
        if (number < 0 || number > 65535) {
            throw new IllegalArgumentRangeException(1, 65535, number);
        }
        this.frameNumber = number;
    }

    public GotoFrame(GotoFrame object) {
        this.frameNumber = object.frameNumber;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public GotoFrame copy() {
        return this;
    }

    public String toString() {
        return String.format(FORMAT, this.frameNumber);
    }

    @Override
    public int prepareToEncode(Context context) {
        return 5;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeByte(129);
        coder.writeShort(2);
        coder.writeShort(this.frameNumber);
    }
}

