/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class MovieAttributes
implements MovieTag {
    private static final String FORMAT = "MovieAttributes: { metadata=%b;  as3=%b;  network=%b; gpu=%b; directBlit=%b}";
    private transient int attributes;

    public MovieAttributes() {
    }

    public MovieAttributes(SWFDecoder coder) throws IOException {
        int length = coder.readUnsignedShort() & 0x3F;
        if (length == 63) {
            length = coder.readInt();
        }
        this.attributes = coder.readByte();
        coder.skip(length - 1);
    }

    public MovieAttributes(MovieAttributes object) {
        this.attributes = object.attributes;
    }

    public boolean hasMetaData() {
        return (this.attributes & 0x10) != 0;
    }

    public boolean hasAS3() {
        return (this.attributes & 8) != 0;
    }

    public boolean useDirectBlit() {
        return (this.attributes & 0x40) != 0;
    }

    public void setUseDirectBlit(boolean useBlit) {
        this.attributes = useBlit ? (this.attributes |= 0x40) : (this.attributes &= 0xFFFFFFBF);
    }

    public boolean useGPU() {
        return (this.attributes & 0x20) != 0;
    }

    public void setUseGPU(boolean useGPU) {
        this.attributes = useGPU ? (this.attributes |= 0x20) : (this.attributes &= 0xFFFFFFDF);
    }

    public boolean useNetwork() {
        return (this.attributes & 1) != 0;
    }

    public void setUseNetwork(boolean useNetwork) {
        this.attributes = useNetwork ? (this.attributes |= 1) : (this.attributes &= 0xFFFFFFFE);
    }

    @Override
    public MovieAttributes copy() {
        return new MovieAttributes(this);
    }

    public String toString() {
        return String.format(FORMAT, this.hasMetaData(), this.hasAS3(), this.useNetwork(), this.useGPU(), this.useDirectBlit());
    }

    @Override
    public int prepareToEncode(Context context) {
        return 6;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        coder.writeShort(4420);
        coder.writeByte(this.attributes);
        coder.writeByte(0);
        coder.writeByte(0);
        coder.writeByte(0);
    }
}

