/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class FrameLabel
implements MovieTag {
    private static final String FORMAT = "FrameLabel: { label=%s; anchor=%s}";
    private String label;
    private boolean anchor;
    private transient int length;

    public FrameLabel(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        this.label = coder.readString();
        if (coder.bytesRead() < this.length) {
            this.anchor = coder.readByte() != 0;
        }
        coder.check(this.length);
        coder.unmark();
    }

    public FrameLabel(String aString) {
        this.setLabel(aString);
    }

    public FrameLabel(String aString, boolean isAnchor) {
        this.setLabel(aString);
        this.anchor = isAnchor;
    }

    public FrameLabel(FrameLabel object) {
        this.label = object.label;
        this.anchor = object.anchor;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String aString) {
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.label = aString;
    }

    public boolean isAnchor() {
        return this.anchor;
    }

    public void setAnchor(boolean anchored) {
        this.anchor = anchored;
    }

    @Override
    public FrameLabel copy() {
        return new FrameLabel(this);
    }

    public String toString() {
        return String.format(FORMAT, this.label, String.valueOf(this.anchor));
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = context.strlen(this.label);
        this.length += this.anchor ? 1 : 0;
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(2815);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xAC0 | this.length);
        }
        coder.writeString(this.label);
        if (this.anchor) {
            coder.writeByte(1);
        }
    }
}

