/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.MovieTag;
import com.flagstone.transform.coder.Context;
import com.flagstone.transform.coder.SWFDecoder;
import com.flagstone.transform.coder.SWFEncoder;
import java.io.IOException;

public final class EnableDebugger
implements MovieTag {
    private static final String FORMAT = "EnableDebugger: { password=%s}";
    private String password;
    private transient int length;

    public EnableDebugger(SWFDecoder coder) throws IOException {
        this.length = coder.readUnsignedShort() & 0x3F;
        if (this.length == 63) {
            this.length = coder.readInt();
        }
        coder.mark();
        coder.readUnsignedShort();
        this.password = coder.readString();
        coder.check(this.length);
        coder.unmark();
    }

    public EnableDebugger(String pass) {
        this.setPassword(pass);
    }

    public EnableDebugger(EnableDebugger object) {
        this.password = object.password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String aString) {
        if (aString == null || aString.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.password = aString;
    }

    @Override
    public EnableDebugger copy() {
        return new EnableDebugger(this);
    }

    public String toString() {
        return String.format(FORMAT, this.password);
    }

    @Override
    public int prepareToEncode(Context context) {
        this.length = 2 + context.strlen(this.password);
        return (this.length > 62 ? 6 : 2) + this.length;
    }

    @Override
    public void encode(SWFEncoder coder, Context context) throws IOException {
        if (this.length > 62) {
            coder.writeShort(3775);
            coder.writeInt(this.length);
        } else {
            coder.writeShort(0xE80 | this.length);
        }
        coder.writeShort(0);
        coder.writeString(this.password);
    }
}

