/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.AbstractCaptureApplet;
import com.hammurapi.jcapture.CaptureConfig;
import com.hammurapi.jcapture.FragmentImpl;
import com.hammurapi.jcapture.FrameImpl;
import com.hammurapi.jcapture.Movie;
import com.hammurapi.jcapture.Region;
import com.hammurapi.jcapture.ScreenShot;
import com.hammurapi.jcapture.ShapeImpl;
import com.hammurapi.jcapture.VideoEncoder;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.ProgressMonitor;

public class ScreenRecorder {
    private CaptureConfig config;
    private Closeable imagesFileCloseable;
    LinkedList<Fragment> fragments = new LinkedList();
    private FileChannel imagesChannel;
    long frameLength;
    private TargetDataLine targetDataLine;

    public ScreenRecorder(CaptureConfig config, AbstractCaptureApplet applet) throws Exception {
        this.config = config;
        final File imagesFile = File.createTempFile("jCaptureImages", ".tmp");
        imagesFile.deleteOnExit();
        final RandomAccessFile raf = new RandomAccessFile(imagesFile, "rw");
        this.imagesChannel = raf.getChannel();
        this.imagesFileCloseable = new Closeable(){

            @Override
            public void close() throws IOException {
                ScreenRecorder.this.imagesChannel.close();
                raf.close();
                if (!imagesFile.delete()) {
                    imagesFile.deleteOnExit();
                }
            }
        };
        applet.addCloseable(this.imagesFileCloseable);
        if (config.isSound()) {
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, config.getAudioFormat());
            Mixer mixer = null;
            Mixer firstMixer = null;
            for (Mixer.Info mi : AudioSystem.getMixerInfo()) {
                Mixer mx = AudioSystem.getMixer(mi);
                if (!mx.isLineSupported(info)) continue;
                if (firstMixer == null) {
                    firstMixer = mx;
                }
                if (config.getMixerName() != null && !mi.getName().equals(config.getMixerName())) continue;
                mixer = mx;
                break;
            }
            if (mixer == null) {
                mixer = firstMixer;
            }
            if (mixer != null) {
                this.targetDataLine = (TargetDataLine)mixer.getLine(info);
                this.targetDataLine.open(config.getAudioFormat());
            }
        }
        this.frameLength = (long)(1000.0 / (double)config.getFramesPerSecond());
        this.start();
    }

    public synchronized void start() throws Exception {
        this.fragments.add(new Fragment());
    }

    public void stop() throws Exception {
        this.fragments.getLast().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Movie getMovie() throws Exception {
        this.stop();
        if (this.targetDataLine != null) {
            this.targetDataLine.close();
        }
        int totalWork = 3;
        for (Fragment f : this.fragments) {
            totalWork += f.screenshots.size() + 1;
        }
        IdentityHashMap<Region, VideoEncoder.Fragment.Frame.Shape.Image> imageCache = new IdentityHashMap<Region, VideoEncoder.Fragment.Frame.Shape.Image>();
        Dimension frameDimension = null;
        ProgressMonitor progressMonitor = new ProgressMonitor(this.config.getParentComponent(), "Encoding video", "Preparing frames", 0, totalWork + 4);
        try {
            int progressCounter = 0;
            int inactivityInterval = this.config.isRemoveInactivity() && !this.config.isSound() ? (int)(1000.0 * this.config.getInactivityInterval() / (double)this.frameLength) : -1;
            float fps = -1.0f;
            ArrayList<VideoEncoder.Fragment> fragmentCollector = new ArrayList<VideoEncoder.Fragment>();
            for (Fragment fragment : this.fragments) {
                if (progressMonitor.isCanceled()) {
                    Movie movie = null;
                    return movie;
                }
                if (fps < 0.0f) {
                    fps = this.config.isSound() ? fragment.getActualFps() : this.config.getSpeedScale() * fragment.getActualFps();
                }
                progressMonitor.setProgress(++progressCounter);
                int lastActivity = -1;
                ArrayList<FrameImpl> framesCollector = new ArrayList<FrameImpl>();
                for (Future<ScreenShot> sf : fragment.screenshots) {
                    if (progressMonitor.isCanceled()) {
                        Movie movie = null;
                        return movie;
                    }
                    ScreenShot screenShot = sf.get();
                    if (inactivityInterval < 0 || screenShot.isActive() || screenShot.getSecNo() - lastActivity < inactivityInterval) {
                        ArrayList<VideoEncoder.Fragment.Frame.Shape> frameShapes = new ArrayList<VideoEncoder.Fragment.Frame.Shape>();
                        for (Region region : screenShot.getRegions()) {
                            VideoEncoder.Fragment.Frame.Shape.ShapeContent content;
                            if (region.getMasterImageRegion() == null) {
                                content = new ShapeImpl.ImageImpl(region.getImage(), region.coversEverything());
                                imageCache.put(region, (VideoEncoder.Fragment.Frame.Shape.Image)content);
                                if (frameDimension == null && region.coversEverything()) {
                                    frameDimension = region.getSize();
                                }
                            } else {
                                content = new ShapeImpl.ImageReferenceImpl((VideoEncoder.Fragment.Frame.Shape.Image)imageCache.get(region.getMasterImageRegion()));
                            }
                            frameShapes.add(new ShapeImpl(region.getImageLocation(), content));
                        }
                        framesCollector.add(new FrameImpl(frameShapes, screenShot.getMousePosition(), screenShot.getSize(), screenShot.isActive()));
                    } else {
                        progressMonitor.setProgress(++progressCounter);
                    }
                    if (screenShot.isActive()) {
                        lastActivity = screenShot.getSecNo();
                    }
                    progressMonitor.setProgress(++progressCounter);
                }
                fragmentCollector.add(new FragmentImpl(Collections.unmodifiableList(framesCollector), fragment.audioSink));
            }
            Movie movie = new Movie(frameDimension, fps, fragmentCollector, this.imagesFileCloseable);
            return movie;
        }
        finally {
            progressMonitor.close();
        }
    }

    private static abstract class SafeThread
    extends Thread {
        private Exception exception;

        public SafeThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                this.exception = e;
                e.printStackTrace();
            }
        }

        protected abstract void runInternal() throws Exception;

        public Exception getException() {
            return this.exception;
        }
    }

    class Fragment {
        private ScreenShot first;
        File audioSink;
        List<Future<ScreenShot>> screenshots = new ArrayList<Future<ScreenShot>>();
        AudioRecordingThread audioRecordingThread;
        ScreenCapturingThread screenCapturingThread;
        volatile boolean isDone;

        float getActualFps() {
            return this.first.getFramesPerSecond();
        }

        public Fragment() throws Exception {
            if (ScreenRecorder.this.targetDataLine != null) {
                this.audioSink = File.createTempFile("jCaptureAudioSink", ".wav");
                ScreenRecorder.this.targetDataLine.start();
                this.audioRecordingThread = new AudioRecordingThread();
                this.audioRecordingThread.start();
            }
            this.screenCapturingThread = new ScreenCapturingThread();
            this.screenCapturingThread.start();
        }

        void stop() throws Exception {
            if (ScreenRecorder.this.targetDataLine != null) {
                ScreenRecorder.this.targetDataLine.stop();
            }
            this.isDone = true;
            if (this.audioRecordingThread != null) {
                this.audioRecordingThread.join();
            }
            this.screenCapturingThread.join();
            if (this.screenCapturingThread.getException() != null) {
                throw this.screenCapturingThread.getException();
            }
            if (this.audioRecordingThread != null && this.audioRecordingThread.getException() != null) {
                throw this.audioRecordingThread.getException();
            }
        }

        private class ScreenCapturingThread
        extends SafeThread {
            public ScreenCapturingThread() {
                super("Screen capturing thread");
            }

            @Override
            protected void runInternal() throws Exception {
                long start = System.currentTimeMillis();
                ScreenShot screenShot = null;
                int shot = 0;
                while (!Fragment.this.isDone) {
                    long toSleep = (long)(shot + 1) * ScreenRecorder.this.frameLength - (System.currentTimeMillis() - start);
                    if (toSleep > 0L) {
                        Thread.sleep(toSleep);
                    }
                    screenShot = ScreenRecorder.this.config.createScreenShot(screenShot, ScreenRecorder.this.imagesChannel);
                    if (Fragment.this.first == null) {
                        Fragment.this.first = screenShot;
                    }
                    Fragment.this.screenshots.add(ScreenRecorder.this.config.submit(screenShot));
                    ++shot;
                }
                System.out.println("Captured " + Fragment.this.screenshots.size() + " screenshots");
            }
        }

        private class AudioRecordingThread
        extends SafeThread {
            public AudioRecordingThread() {
                super("Audio recording thread");
            }

            @Override
            protected void runInternal() throws Exception {
                AudioSystem.write(new AudioInputStream(ScreenRecorder.this.targetDataLine), AudioFileFormat.Type.WAVE, Fragment.this.audioSink);
            }
        }
    }
}

