/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.AbstractCaptureApplet;
import com.hammurapi.jcapture.CaptureConfig;
import com.hammurapi.jcapture.CaptureOptionsDialog;
import com.hammurapi.jcapture.ComponentMover;
import com.hammurapi.jcapture.ComponentResizer;
import com.hammurapi.jcapture.RecordingControlsFrame;
import com.hammurapi.jcapture.Translucener;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import netscape.javascript.JSObject;
import org.apache.http.HttpResponse;

public class CaptureFrame
extends JFrame {
    private JPanel capturePanel;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss-SSS");
    private int counter;
    private CaptureConfig captureConfig;
    private AbstractCaptureApplet applet;
    private JButton recordButton;
    private AtomicBoolean capturing = new AtomicBoolean(false);
    private AtomicBoolean recording = new AtomicBoolean(false);

    public CaptureConfig getCaptureConfig() {
        return this.captureConfig;
    }

    public CaptureFrame(AbstractCaptureApplet applet) throws Exception {
        super("Screen capture");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("camera.png")));
        this.setUndecorated(true);
        Translucener.makeFrameTranslucent(this);
        this.setAlwaysOnTop(true);
        this.applet = applet;
        this.captureConfig = new CaptureConfig();
        this.captureConfig.load(applet.loadConfig());
        this.captureConfig.setBackgroundProcessor(applet.getBackgroundProcessor());
        this.capturePanel = new JPanel();
        final JLabel dimensionsLabel = new JLabel("");
        this.capturePanel.add((Component)dimensionsLabel, "Center");
        this.capturePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                dimensionsLabel.setText(e.getComponent().getWidth() + " x " + e.getComponent().getHeight());
            }
        });
        JButton captureButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle bounds = CaptureFrame.this.capturePanel.getBounds();
                Point loc = bounds.getLocation();
                SwingUtilities.convertPointToScreen(loc, CaptureFrame.this.capturePanel);
                bounds.setLocation(loc);
                Properties props = CaptureFrame.this.captureConfig.setRecordingRectangle(bounds);
                if (props != null) {
                    CaptureFrame.this.getApplet().storeConfig(props);
                }
                CaptureFrame.this.capturing.set(true);
                CaptureFrame.this.setVisible(false);
            }
        });
        captureButton.setText("Capture");
        captureButton.setToolTipText("Create a snapshot of the screen");
        this.capturePanel.add((Component)captureButton, "Center");
        this.recordButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle bounds = CaptureFrame.this.capturePanel.getBounds();
                Point loc = bounds.getLocation();
                SwingUtilities.convertPointToScreen(loc, CaptureFrame.this.capturePanel);
                bounds.setLocation(loc);
                Properties props = CaptureFrame.this.captureConfig.setRecordingRectangle(bounds);
                if (props != null) {
                    CaptureFrame.this.getApplet().storeConfig(props);
                }
                CaptureFrame.this.recording.set(true);
                CaptureFrame.this.setVisible(false);
            }
        });
        this.recordButton.setText("Record");
        this.setRecordButtonState();
        this.capturePanel.add((Component)this.recordButton, "Center");
        JButton optionsButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CaptureOptionsDialog(CaptureFrame.this).setVisible(true);
            }
        });
        optionsButton.setText("Options");
        this.capturePanel.add((Component)optionsButton, "Center");
        JButton cancelButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaptureFrame.this.setVisible(false);
            }
        });
        cancelButton.setText("Cancel");
        this.capturePanel.add((Component)cancelButton, "Center");
        this.getContentPane().add((Component)this.capturePanel, "Center");
        this.capturePanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
        if (this.captureConfig.getRecordingRectangle() == null) {
            this.setSize(400, 300);
            this.setLocationRelativeTo(null);
        } else {
            this.setBounds(this.captureConfig.getRecordingRectangle());
        }
        Insets dragInsets = new Insets(5, 5, 5, 5);
        new ComponentResizer(dragInsets, this);
        ComponentMover cm = new ComponentMover();
        cm.registerComponent(this);
        cm.setDragInsets(dragInsets);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (CaptureFrame.this.capturing.get()) {
                    CaptureFrame.this.capturing.set(false);
                    try {
                        CaptureFrame.this.capture();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else if (CaptureFrame.this.recording.get()) {
                    CaptureFrame.this.recording.set(false);
                    CaptureFrame.this.record();
                }
            }
        });
    }

    void setRecordButtonState() {
        if (this.captureConfig.getEncoder() == null) {
            this.recordButton.setEnabled(false);
            this.recordButton.setToolTipText("Video format not selected. Use Options dialog to select video format.");
        } else {
            this.recordButton.setEnabled(true);
            this.recordButton.setToolTipText("Record screen activity and audio");
        }
    }

    public AbstractCaptureApplet getApplet() {
        return this.applet;
    }

    protected void capture() throws Exception {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        BufferedImage screenShot = this.captureConfig.createScreenShot(null, null).call().getRegions().get(0).getImage().getImage();
        String prefix = this.getDatePrefix();
        String defaultImageFormat = this.applet.getParameter("imageFormat");
        if (defaultImageFormat == null || defaultImageFormat.trim().length() == 0) {
            defaultImageFormat = "PNG";
        }
        String defaultFileExtension = defaultImageFormat.toLowerCase();
        final String fileName = JOptionPane.showInputDialog(this, "Upload as", this.applet.getParameter("pageName") + "-capture-" + prefix + "-" + this.nextCounter() + "." + defaultFileExtension);
        if (fileName != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int idx = fileName.lastIndexOf(46);
                String imageFormat = idx == -1 ? defaultImageFormat : fileName.substring(idx + 1).toUpperCase();
                ImageIO.write((RenderedImage)screenShot, imageFormat, baos);
                final byte[] imageBytes = baos.toByteArray();
                System.out.println("Image size: " + imageBytes.length);
                SwingWorker<Boolean, Long> task = new SwingWorker<Boolean, Long>(){
                    private Object errorMessage;
                    private String errorTitle;

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        System.out.println("Uploading in background");
                        try {
                            HttpResponse iResponse = CaptureFrame.this.applet.post(CaptureFrame.this, new ByteArrayInputStream(imageBytes), imageBytes.length, fileName, "application/octet-stream");
                            System.out.println("Response status line: " + iResponse.getStatusLine());
                            if (iResponse.getStatusLine().getStatusCode() != 200) {
                                this.errorMessage = iResponse.getStatusLine();
                                this.errorTitle = "Error saving image";
                                return false;
                            }
                            return true;
                        }
                        catch (Error e) {
                            this.errorMessage = e.toString();
                            this.errorTitle = "Upload error";
                            e.printStackTrace();
                            return false;
                        }
                    }

                    @Override
                    protected void done() {
                        try {
                            if (((Boolean)this.get()).booleanValue()) {
                                JSObject window = JSObject.getWindow((Applet)CaptureFrame.this.applet);
                                String toEval = "insertAtCarret('" + CaptureFrame.this.applet.getParameter("edid") + "','{{:" + fileName + "|}}')";
                                System.out.println("Evaluating: " + toEval);
                                window.eval(toEval);
                                CaptureFrame.this.setVisible(false);
                            } else {
                                JOptionPane.showMessageDialog(CaptureFrame.this, this.errorMessage, this.errorTitle, 0);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(CaptureFrame.this, e.toString(), "Exception", 0);
                        }
                    }
                };
                task.execute();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.applet, ex.toString(), "Error saving image", 0);
            }
        }
    }

    public int nextCounter() {
        return this.counter++;
    }

    public String getDatePrefix() {
        return this.dateFormat.format(new Date());
    }

    protected void record() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        int borderWidth = 1;
        JFrame[] borderFrames = new JFrame[4];
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rr = this.captureConfig.getRecordingRectangle();
        Color borderColor = Color.RED;
        if (rr.x >= borderWidth) {
            borderFrames[0] = new JFrame();
            borderFrames[0].setDefaultCloseOperation(2);
            borderFrames[0].setSize(borderWidth, rr.height + borderWidth * 2);
            borderFrames[0].setLocation(rr.x - borderWidth, rr.y - borderWidth);
            borderFrames[0].setUndecorated(true);
            borderFrames[0].setAlwaysOnTop(true);
            borderFrames[0].setFocusableWindowState(false);
            borderFrames[0].getContentPane().setBackground(borderColor);
        }
        if (rr.x + rr.width < dim.width - borderWidth) {
            borderFrames[1] = new JFrame();
            borderFrames[1].setDefaultCloseOperation(2);
            borderFrames[1].setSize(borderWidth, rr.height + borderWidth * 2);
            borderFrames[1].setLocation(rr.x + rr.width, rr.y - borderWidth);
            borderFrames[1].setUndecorated(true);
            borderFrames[1].setAlwaysOnTop(true);
            borderFrames[1].setFocusableWindowState(false);
            borderFrames[1].getContentPane().setBackground(borderColor);
        }
        if (rr.y >= borderWidth) {
            borderFrames[2] = new JFrame();
            borderFrames[2].setDefaultCloseOperation(2);
            borderFrames[2].setSize(rr.width, borderWidth);
            borderFrames[2].setLocation(rr.x, rr.y - borderWidth);
            borderFrames[2].setUndecorated(true);
            borderFrames[2].setAlwaysOnTop(true);
            borderFrames[2].setFocusableWindowState(false);
            borderFrames[2].getContentPane().setBackground(borderColor);
        }
        if (rr.y + rr.height < dim.height - borderWidth) {
            borderFrames[3] = new JFrame();
            borderFrames[3].setDefaultCloseOperation(2);
            borderFrames[3].setSize(rr.width, borderWidth);
            borderFrames[3].setLocation(rr.x, rr.y + rr.height);
            borderFrames[3].setUndecorated(true);
            borderFrames[3].setAlwaysOnTop(true);
            borderFrames[3].setFocusableWindowState(false);
            borderFrames[3].getContentPane().setBackground(borderColor);
        }
        RecordingControlsFrame inst = new RecordingControlsFrame(this, borderFrames);
        int x = this.getLocation().x + this.getWidth() - inst.getWidth();
        if ((double)(x + inst.getWidth()) > dim.getWidth()) {
            x = dim.width - inst.getWidth();
        } else if (x < 0) {
            x = 0;
        }
        int y = rr.getLocation().y + this.getHeight() + 1;
        if (y + inst.getHeight() > dim.height && (y = rr.getLocation().y - inst.getHeight()) < 0) {
            y = dim.height - inst.getHeight();
        }
        inst.setLocation(x, y);
        inst.setVisible(true);
    }
}

