/*
 * Decompiled with CFR 0.152.
 */
package com.hammurapi.jcapture;

import com.hammurapi.jcapture.ScreenShot;
import com.hammurapi.jcapture.VideoEncoder;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sound.sampled.AudioFormat;

public class CaptureConfig
implements VideoEncoder.Config {
    private static final String MP3_COMMAND_PROPERTY = "mp3command";
    private static final String TOOL_BAR_PROPERTY = "toolBar";
    private static final String SPEED_SCALE_PROPERTY = "speedScale";
    private static final String SOUND_PROPERTY = "sound";
    private static final String SCREEN_SCALE_PROPERTY = "screenScale";
    private static final String REMOVE_INACTIVITY_PROPERTY = "removeInactivity";
    private static final String PLAY_PROPERTY = "play";
    private static final String MOUSE_PROPERTY = "mouse";
    private static final String MIXER_NAME_PROPERTY = "mixerName";
    private static final String LOOP_PROPERTY = "loop";
    private static final String INACTIVITY_INTERVAL_PROPERTY = "inactivityInterval";
    private static final String IMAGE_FORMAT_PROPERTY = "imageFormat";
    private static final String FRAMES_PER_SECOND_PROPERTY = "framesPerSecond";
    private static final String BORDER_PROPERTY = "border";
    private static final String RECORDING_RECTANGLE_PROPERTY = "recordingRectangle";
    private static final String ENCODER_NAME_PROPERTY = "encoderName";
    private static final String AUDIO_FORMAT_SAMPLE_SIZE_PROPERTY = "audioFormat.sampleSize";
    private static final String AUDIO_FORMAT_SAMPLE_RATE_PROPERTY = "audioFormat.sampleRate";
    private static final String AUDIO_FORMAT_CHANNELS_PROPERTY = "audioFormat.channels";
    private AudioFormat audioFormat = new AudioFormat(22050.0f, 16, 1, true, false);
    private String mixerName;
    private float framesPerSecond = 10.0f;
    private double screenScale = 1.0;
    private float speedScale = 1.0f;
    private boolean removeInactivity;
    private double inactivityInterval = 0.7;
    private Component parentComponent;
    private Rectangle recordingRectangle;
    private boolean border = true;
    private boolean toolBar = true;
    private Robot robot = new Robot();
    private String imageFormat = "PNG";
    private boolean sound = true;
    private boolean mouse = true;
    private boolean loop = true;
    private boolean play = false;
    private VideoEncoder encoder;
    private int grabRange = 3;
    private ExecutorService backgroundProcessor;
    private String mp3command;
    private List<VideoEncoder> encoders;

    @Override
    public String getMp3command() {
        return this.mp3command;
    }

    public void setMp3command(String mp3command) {
        this.mp3command = mp3command;
    }

    public int getGrabRange() {
        return this.grabRange;
    }

    public ExecutorService getBackgroundProcessor() {
        return this.backgroundProcessor;
    }

    public void setBackgroundProcessor(ExecutorService backgroundProcessor) {
        this.backgroundProcessor = backgroundProcessor;
    }

    public void setGrabRange(int grabRange) {
        this.grabRange = grabRange;
    }

    public VideoEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(VideoEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public boolean isPlay() {
        return this.play;
    }

    public void setPlay(boolean play) {
        this.play = play;
    }

    public boolean isSound() {
        return this.sound;
    }

    public void setSound(boolean sound) {
        this.sound = sound;
    }

    public boolean isMouse() {
        return this.mouse;
    }

    public void setMouse(boolean mouse) {
        this.mouse = mouse;
    }

    @Override
    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public CaptureConfig() throws AWTException {
        ServiceLoader<VideoEncoder> sl = ServiceLoader.load(VideoEncoder.class);
        ArrayList<VideoEncoder> accumulator = new ArrayList<VideoEncoder>();
        Iterator<VideoEncoder> vit = sl.iterator();
        while (vit.hasNext()) {
            accumulator.add(vit.next());
        }
        Collections.sort(accumulator, new Comparator<VideoEncoder>(){

            @Override
            public int compare(VideoEncoder o1, VideoEncoder o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        this.encoders = Collections.unmodifiableList(accumulator);
        if (this.encoder == null && !this.encoders.isEmpty()) {
            this.encoder = this.encoders.get(0);
        }
    }

    public Future<ScreenShot> submit(ScreenShot task) {
        return this.backgroundProcessor.submit(task);
    }

    public Robot getRobot() {
        return this.robot;
    }

    public ScreenShot createScreenShot(ScreenShot prev, FileChannel imageChannel) throws IOException {
        BufferedImage image = this.robot.createScreenCapture(this.recordingRectangle);
        Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
        if (this.mouse && this.recordingRectangle.contains(mouseLocation)) {
            mouseLocation.move(mouseLocation.x - this.recordingRectangle.x, mouseLocation.y - this.recordingRectangle.y);
        } else {
            mouseLocation = null;
        }
        return new ScreenShot(image, mouseLocation, prev, System.currentTimeMillis(), this.grabRange, this.isTransparencySupported(), this.border, this.getScreenScale(), imageChannel, this.getImageFormat());
    }

    public boolean isTransparencySupported() {
        return !"jpeg".equalsIgnoreCase(this.getImageFormat()) && !"jpg".equalsIgnoreCase(this.getImageFormat());
    }

    @Override
    public boolean isToolBar() {
        return this.toolBar;
    }

    public void setToolBar(boolean toolBar) {
        this.toolBar = toolBar;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public Rectangle getRecordingRectangle() {
        return this.recordingRectangle;
    }

    public Properties setRecordingRectangle(Rectangle recordingRectangle) {
        Rectangle oldValue = this.recordingRectangle;
        this.recordingRectangle = recordingRectangle;
        if (this.recordingRectangle != null && !this.recordingRectangle.equals(oldValue)) {
            return this.store();
        }
        return null;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    public String getMixerName() {
        return this.mixerName;
    }

    public void setMixerName(String mixerName) {
        this.mixerName = mixerName;
    }

    public float getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public void setFramesPerSecond(float framesPerSecond) {
        this.framesPerSecond = framesPerSecond;
    }

    @Override
    public double getScreenScale() {
        return this.screenScale;
    }

    public void setScreenScale(double screenScale) {
        this.screenScale = screenScale;
    }

    public float getSpeedScale() {
        return this.speedScale;
    }

    public void setSpeedScale(float speedScale) {
        this.speedScale = speedScale;
    }

    public boolean isRemoveInactivity() {
        return this.removeInactivity;
    }

    public void setRemoveInactivity(boolean removeInactivity) {
        this.removeInactivity = removeInactivity;
    }

    public double getInactivityInterval() {
        return this.inactivityInterval;
    }

    public void setInactivityInterval(double inactivityInterval) {
        this.inactivityInterval = inactivityInterval;
    }

    @Override
    public Component getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    void load(Properties properties) {
        if (properties != null) {
            try {
                String rr;
                if (properties.containsKey(AUDIO_FORMAT_CHANNELS_PROPERTY)) {
                    this.audioFormat = new AudioFormat(Float.parseFloat(properties.getProperty(AUDIO_FORMAT_SAMPLE_RATE_PROPERTY, String.valueOf(this.audioFormat.getSampleRate()))), Integer.parseInt(properties.getProperty(AUDIO_FORMAT_SAMPLE_SIZE_PROPERTY, String.valueOf(this.audioFormat.getSampleSizeInBits()))), Integer.parseInt(properties.getProperty(AUDIO_FORMAT_CHANNELS_PROPERTY, String.valueOf(this.audioFormat.getChannels()))), true, false);
                }
                this.border = Boolean.parseBoolean(properties.getProperty(BORDER_PROPERTY, String.valueOf(this.border)));
                this.framesPerSecond = Float.parseFloat(properties.getProperty(FRAMES_PER_SECOND_PROPERTY, String.valueOf(this.framesPerSecond)));
                this.imageFormat = properties.getProperty(IMAGE_FORMAT_PROPERTY, String.valueOf(this.imageFormat));
                this.inactivityInterval = Double.parseDouble(properties.getProperty(INACTIVITY_INTERVAL_PROPERTY, String.valueOf(this.inactivityInterval)));
                this.loop = Boolean.parseBoolean(properties.getProperty(LOOP_PROPERTY, String.valueOf(this.loop)));
                this.mixerName = properties.getProperty(MIXER_NAME_PROPERTY, String.valueOf(this.mixerName));
                this.mouse = Boolean.parseBoolean(properties.getProperty(MOUSE_PROPERTY, String.valueOf(this.mouse)));
                this.play = Boolean.parseBoolean(properties.getProperty(PLAY_PROPERTY, String.valueOf(this.play)));
                this.removeInactivity = Boolean.parseBoolean(properties.getProperty(REMOVE_INACTIVITY_PROPERTY, String.valueOf(this.removeInactivity)));
                this.screenScale = Double.parseDouble(properties.getProperty(SCREEN_SCALE_PROPERTY, String.valueOf(this.screenScale)));
                this.sound = Boolean.parseBoolean(properties.getProperty(SOUND_PROPERTY, String.valueOf(this.sound)));
                this.speedScale = Float.parseFloat(properties.getProperty(SPEED_SCALE_PROPERTY, String.valueOf(this.speedScale)));
                this.toolBar = Boolean.parseBoolean(properties.getProperty(TOOL_BAR_PROPERTY, String.valueOf(this.toolBar)));
                this.mp3command = properties.getProperty(MP3_COMMAND_PROPERTY);
                this.encoder = null;
                String encoderName = properties.getProperty(ENCODER_NAME_PROPERTY);
                if (encoderName != null) {
                    for (VideoEncoder candidate : this.getEncoders()) {
                        if (!encoderName.equals(candidate.toString())) continue;
                        this.encoder = candidate;
                        break;
                    }
                }
                if (this.encoder == null && !this.getEncoders().isEmpty()) {
                    this.encoder = this.getEncoders().get(0);
                }
                if ((rr = properties.getProperty(RECORDING_RECTANGLE_PROPERTY)) != null && rr.trim().length() > 0) {
                    String[] dims = rr.split(";");
                    this.recordingRectangle = new Rectangle(Integer.parseInt(dims[0]), Integer.parseInt(dims[1]), Integer.parseInt(dims[2]), Integer.parseInt(dims[3]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<VideoEncoder> getEncoders() {
        return this.encoders;
    }

    Properties store() {
        Properties properties = new Properties();
        if (this.audioFormat != null) {
            properties.setProperty(AUDIO_FORMAT_CHANNELS_PROPERTY, String.valueOf(this.audioFormat.getChannels()));
            properties.setProperty(AUDIO_FORMAT_SAMPLE_RATE_PROPERTY, String.valueOf(this.audioFormat.getSampleRate()));
            properties.setProperty(AUDIO_FORMAT_SAMPLE_SIZE_PROPERTY, String.valueOf(this.audioFormat.getSampleSizeInBits()));
        }
        properties.setProperty(BORDER_PROPERTY, String.valueOf(this.border));
        properties.setProperty(FRAMES_PER_SECOND_PROPERTY, String.valueOf(this.framesPerSecond));
        properties.setProperty(IMAGE_FORMAT_PROPERTY, String.valueOf(this.imageFormat));
        properties.setProperty(INACTIVITY_INTERVAL_PROPERTY, String.valueOf(this.inactivityInterval));
        properties.setProperty(LOOP_PROPERTY, String.valueOf(this.loop));
        properties.setProperty(MIXER_NAME_PROPERTY, String.valueOf(this.mixerName));
        properties.setProperty(MOUSE_PROPERTY, String.valueOf(this.mouse));
        properties.setProperty(PLAY_PROPERTY, String.valueOf(this.play));
        properties.setProperty(REMOVE_INACTIVITY_PROPERTY, String.valueOf(this.removeInactivity));
        properties.setProperty(SCREEN_SCALE_PROPERTY, String.valueOf(this.screenScale));
        properties.setProperty(SOUND_PROPERTY, String.valueOf(this.sound));
        properties.setProperty(SPEED_SCALE_PROPERTY, String.valueOf(this.speedScale));
        properties.setProperty(TOOL_BAR_PROPERTY, String.valueOf(this.toolBar));
        if (this.recordingRectangle != null) {
            properties.setProperty(RECORDING_RECTANGLE_PROPERTY, this.recordingRectangle.x + ";" + this.recordingRectangle.y + ";" + this.recordingRectangle.width + ";" + this.recordingRectangle.height);
        }
        if (this.mp3command != null) {
            properties.setProperty(MP3_COMMAND_PROPERTY, this.mp3command);
        }
        if (this.encoder != null) {
            properties.setProperty(ENCODER_NAME_PROPERTY, this.encoder.toString());
        }
        return properties;
    }
}

